# 
# Copyright (C) 2007 OpenWrt.org
#
# This is free software, licensed under the GNU General Public License v2.
# See /LICENSE for more information.
#
# define a dependency on a subtree
# parameters:
#	1: directories/files
#	2: directory dependency
#	3: tempfile for file listings
#	4: find options

DEP_FINDPARAMS := -x "*.svn*" -x ".*" -x "*.svn*" -x "*:*" -x "*\!*" -x "* *" -x "*\\\#*" -x "*/.*_check"

find_md5=find $(1) -type f $(patsubst -x,-and -not -path,$(DEP_FINDPARAMS) $(2)) | md5s

define rdep
  .PRECIOUS: $(2)
  .SILENT: $(2)_check

  $(2): $(2)_check
  $(2)_check::
	if [ -f "$(2)" ]; then \
		$(if $(3), \
			$(call find_md5,$(1),$(4)) > $(3).1; \
			{ [ \! -f "$(3)" ] || diff $(3) $(3).1 >/dev/null; } && \
		) \
		{ \
			[ -f "$(2)_check.1" ] && mv "$(2)_check.1"; \
		    $(TOPDIR)/scripts/timestamp.pl $(DEP_FINDPARAMS) $(4) -n $(2) $(1) && { \
				$(call debug_eval,$(SUBDIR),r,echo "No need to rebuild $(2)";) \
				touch -r "$(2)" "$(2)_check"; \
			} \
		} || { \
			$(call debug_eval,$(SUBDIR),r,echo "Need to rebuild $(2)";) \
			touch "$(2)_check"; \
		}; \
		$(if $(3), mv $(3).1 $(3);) \
	else \
		$(if $(3), rm -f $(3) $(3).1;) \
		$(call debug_eval,$(SUBDIR),r,echo "Target $(2) not built";) \
		true; \
	fi

endef

