#!/bin/sh
# Copyright (C) 2009 Draytek
# This script will be executed from dray_fwup to check WAN status
# echo 1: arp/ping detect success... WAN status is ok
# echo 0: arp/ping detect failed...WAN status may down.

check_time() {
	Idle=$(uci -q get network.$iface.det_idle || echo "")	# the idle time
	Idle="${Idle:-5}"
	let senttime=sent_time_$iface
	if [ $senttime -gt 30 ]; then
		INTV=$(($now - $senttime))
		if [ "$INTV" -ge 10 ]; then	## delay too long from last detection; CPU busy? 
			logger -p 160.5 "[WAN] Stop $iface detection checking, busy?"
			return 2
		fi
	fi
	let pingtime=resp_time_$iface
	if [ $senttime -gt $pingtime ]; then
		DIFF=$(($senttime - $pingtime))
		#logger -p 160.5 "[WAN] debug $DIFF $now $pingtime" 
		if [ "$DIFF" -ge "$Idle" ]; then
			return 0
		else
			return 1
		fi
	else
		return 1
	fi
}

check_dual_3G() {
    # check 3G backup or load balance
    if [ "$backup" == "1" ]; then 
        wan_mode=$(uci -P /var/state/ -q get network.wan.proto)
        if [ "$wan_mode" == "3g" ] && [ "$load_balance" == "1" ]; then        
      	    # check wan is up
      	    if [ "$(uci -P /var/state/ -q get network.wan.up)" != "1" ]; then
      	        logger -p 160.5 "[WAN 3G Load Balance] --------- WAN is down, bring up WAN ------"
      		    nice -n 0 ifup wan &
      	    fi
      	    # check 3gwan is up      	    
      	    if [ "$(uci -P /var/state/ -q get network.3gwan.up)" != "1" ]; then
      	        logger -p 160.5 "[WAN 3G Load Balance] --------- 3GWAN is down, bring up 3GWAN ------"
      	        nice -n 0 ifup 3gwan &
      	    fi	
        else
      	    # check 3gwan is up
      	    if [ "$(uci -P /var/state/ -q get network.3gwan.up)" != "1" ]; then
      		    if [ "$(uci -P /var/state/ -q get network.wan.up)" != "1" ]; then
      			    logger -p 160.5 "[WAN Backup] ---------WAN is down, start Backup WAN ------"
      			    nice -n 0 ifup 3gwan &
      		    fi
      	    else
      		    if [ "$(uci -P /var/state/ -q get network.wan.up)" == "1" ]; then
      			    logger -p 160.5 "[WAN Backup] ************* WAN is up, stop Backup WAN ************"
      			    nice -n 0 ifdown 3gwan &
      		    fi	  		
      	    fi 
        fi     
    fi 
}

#when do arp/ping successful, sleep 1 sec
resp_time_save() {
	let resp_time_$iface=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
	sleep 1
}

sent_time_save() {
	let sent_time_$iface=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
}

send_arping() {
	#if enable ping detect
	wantype=$(uci -q get network.$iface.proto)
	
	sent_time_save
	if [ "$Mode" == "1" ]; then
		Host=$(uci -q get network.$iface.pingip || echo "")
		[ -n "$Host" ] && {
			ping -c 1 -W 2 -I $ifout "$Host" >/dev/null 2>&1 && resp_time_save
		}
	else
		# do arp detect
		if [ "$wantype" = "static" ] ; then
			gateway=$(uci -q get network.$iface.gateway)
			ipaddr=$(uci -q get network.$iface.ipaddr)
			arping -f -c 2 -w 2 -I $ifout "$gateway" ${ipaddr:+-s $ipaddr} 2>/dev/null | grep -q "reply from $gateway" && resp_time_save
		elif [ "$wantype" = "pppoe" -o "$wantype" = "LTE" ] ; then
			[ "$wanup" == "1" ] && resp_time_save
		elif [ "$wantype" = "dhcp" ] ; then
			gateway=$(uci -q -P /var/state get network.$iface.gateway)
			ipaddr=$(uci -q -P /var/state get network.$iface.ipaddr)
			if [ -n "$gateway" -a -n "$ipaddr" ]; then
				arping -f -c 2 -w 2 -I $ifout "$gateway -s $ipaddr" 2>/dev/null | grep -q "reply from $gateway" && resp_time_save
			else
				[ "$wanup" == "1" ] && resp_time_save
			fi
		else
			[ "$wanup" == "1" ] && resp_time_save
		fi
	fi
}

check_ipv6_wan_conf_value() {
	temp=$(uci -P /var/state get ipv6.wan.mode)
	temp1=$(cat /proc/sys/net/ipv6/conf/br-wan/forwarding 2>/dev/null)
	temp2=$(cat /proc/sys/net/ipv6/conf/br-wan/accept_ra_pinfo 2>/dev/null)
	if [ "$temp" == "dhcpv6" -o "$temp" == "dhcpv6-3" -o "$temp" == "dhcpv6-4" ]; then
		# nancy, receive RA from WAN interface, do not set prefix of RA from WAN
		if [ "$temp2" == "1" ]; then
			echo 0 > /proc/sys/net/ipv6/conf/br-wan/accept_ra_pinfo 2>/dev/null
		fi
		if [ "$temp1" == "1" ]; then	
			echo 0 > /proc/sys/net/ipv6/conf/br-wan/forwarding 2>/dev/null
		fi
	else
		if [ "$temp1" == "0" ]; then	
			echo 1 > /proc/sys/net/ipv6/conf/br-wan/forwarding 2>/dev/null
		fi
		if [ "$temp2" == "0" ]; then
			echo 1 > /proc/sys/net/ipv6/conf/br-wan/accept_ra_pinfo 2>/dev/null
		fi
	fi
}

while [ 1 ]
do
  for iface in wan 3gwan mngtwan iptvwan voipwan ; do 
	Mode=$(uci -q get network.$iface.detect || echo "0")	# 0:arp; 1:ping; 2:disabled
	wanup=$(uci -P /var/state/ -q get network.$iface.up || echo "0")
	now=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
	wan_uptime=$(uci -P /var/state/ -q get network.$iface.uptime | awk 'FS="[.]+" {print $1}')
	wan_uptime="${wan_uptime:-0}"
	backup=$(uci -q get network.3gwan.backup)
	load_balance=$(uci -q get network.3gwan.load_balance)

	if [ "$iface" == "wan" ]; then
		check_ipv6_wan_conf_value
	fi
	
	[ "$Mode" == "2" -o $now -le 120 ] && {
		#echo "2"
		continue
	}
	if [ $iface == "3gwan" ]; then
		[ "$backup" != "1" -o "$(uci -P /var/state/ -q get network.wan.up)" == "1" ] && continue
	fi

	if [ $iface == "mngtwan" -o $iface == "iptvwan" -o $iface == "voipwan" ]; then
		vwan_disable=$(uci -q get network.$iface.disable 2>/dev/null || echo 1)
		[ "$vwan_disable" == "1" ] && continue
	fi

	ifout=$(uci -P /var/state/ -q get network.$iface.ifname)
	[ $ifout == "" ] && continue

	let a=fail_$iface
	send_arping	
	check_time
	ret=$?
	#logger -p 160.5 "[WAN] debug : detect $iface ret=$ret " 
	case $ret in
	0)	# wan detect fail
		let a=a+1
		let fail_$iface=a
		#logger -p 160.5 "[WAN] ---------debug fail_$iface count = $a ------"
		if [ $wanup == "1" ]; then
			if [ $a -gt 4 ]; then
				logger -p 160.5 "[WAN] --------------  wan detect fail, disconnect $iface "
				uci -q -P /var/state revert network.$iface.up
				[ "$Mode" == "1" ] && route del default dev $ifout &
				let fail_$iface=0
				check_dual_3G
				continue
			fi
		else
			[ "$wan_uptime" == "0" ] && continue
			diff=$(($now - $wan_uptime))
			#logger -p 160.5 "[WAN] ---------debug fail_time = $diff ------"
			[ $a -gt 10 -a "$diff" -gt "60" ] && {
				logger -p 160.5 "[WAN] --------------  wan detect fail more than 10 times and 60 sec, restart $iface "
				let fail_$iface=0
				nice -n 0 ifup $iface &
				check_dual_3G
				continue
			}		
		fi
		;;
	1)  # wan detect OK
		let fail_$iface=0
		gateway=$(uci -q -P /var/state get network.$iface.gateway)
		if [ $wanup != "1" ]; then
			uci -q -P /var/state set network.$iface.up=1
			if [ "$Mode" == "1" ]; then
				logger -p 160.5 "[WAN] *************** ping detect success, interface $iface up"
				[ "$ifout" = "ppp0" -o "$ifout" = "ppp1" ] && {
					route add default dev $ifout >/dev/null 2>&1
					/etc/init.d/ipsec restart
				}
				(ACTION="ifup" INTERFACE="$iface" . /etc/hotplug.d/iface/20-firewall &)
				[ "$ifout" != "ppp0" -a "$ifout" != "ppp1" ] && {
					route add default gw "$gateway" dev "$ifout" >/dev/null 2>&1
					/etc/init.d/ipsec restart
				}
				check_dual_3G
				# ntp
				browser_time=`uci -q get ntpclient.@browser_time[-1].enabled || echo 0`
				[ "$iface" == "wan" -a "$browser_time" == "0" ] && (killall -q ntpquery ntpclient; /usr/sbin/ntpquery) > /dev/null
				sh /lib/firewall/user.sh &
				continue
			fi	
		else
			route -n | grep '^0.0.0.0' >/dev/null 2>&1 || {
				[ "$iface" = "wan" -o "$iface" = "3gwan" ] && {
					[ "$ifout" = "ppp0" -o "$ifout" = "ppp1" ] && {
						route add default dev $ifout >/dev/null 2>&1
						/etc/init.d/ipsec restart
					}
					logger -p 160.5 "[WAN] ***************no default route, add default interface $ifout "
				}
			}

			vwan_ip=$(ifconfig $ifout 2>/dev/null | grep "inet addr")
			vwantype=$(uci -q get network.$iface.proto)
			[ "$vwantype" == "dhcp" -a "$vwan_ip" == "" ] && {
				logger -p 160.5 "[WAN] *************** $iface up but no ip address, restart it "
				nice -n 0 ifup $iface
			}
		fi	
		;;	
	2)  # wan busy
		let fail_$iface=0
		[ $iface == "wan" ] && check_dual_3G
		;;
	*)
		let fail_$iface=0	
		;;
	esac		
  done
  let counter=$counter+1
  if [ $counter -gt 30 ]; then
	check_dual_3G	
	let counter=0
  fi
  sleep 1
done
