#!/bin/sh

# Copyright (C) 2012 Draytek
# to start/stop 6to4 tunneling

LAN=br-lan
CONF=/etc/radvd.conf

usage()
{
  echo "usage:" >&2
  echo "  $0 <start|stop>" >&2
  exit 1
}

config_radvd()
{
  LIFETIME=`uci -q get ipv6.lan_radvd.adv_time`

  echo "interface $LAN" > $CONF
  echo "{" >> $CONF
  echo "  AdvSendAdvert on;" >> $CONF
  echo "  MinRtrAdvInterval 3;" >> $CONF
  echo "  MaxRtrAdvInterval 10;" >> $CONF
  if [ $LIFETIME ]; then
    echo "  AdvDefaultLifetime $LIFETIME;" >> $CONF
  fi

  echo "  prefix 0:0:0:1::/64" >> $CONF
  echo "  {" >> $CONF
  echo "    AdvOnLink on;" >> $CONF
  echo "    AdvAutonomous on;" >> $CONF
  echo "    AdvRouterAddr on;" >> $CONF
  echo "    AdvValidLifetime 2592000;" >> $CONF
  echo "    AdvPreferredLifetime 604800;" >> $CONF
  echo "    Base6to4Interface $WAN;" >> $CONF
  echo "  };" >> $CONF

  echo "};" >> $CONF
  echo "" >> $CONF
  chmod 600 $CONF
}

start_radvd()
{
  killall radvd 2>/dev/null
  config_radvd
  radvd -C $CONF
}

start_6to4()
{
  if [ $WANIP ]; then
    PREFIX=$(echo $WANIP | awk '{FS="."} {printf "2002:%02x%02x:%02x%02x", $1, $2, $3, $4}')
    ip tunnel add tun6to4 mode sit ttl 255 remote any local $WANIP
    ip link set tun6to4 up
    ip addr add $PREFIX:0::1/16 dev tun6to4
    ip addr add $PREFIX:1::1/64 dev $LAN
    ip -6 route del 2000::/3 2>/dev/null
    ip -6 route add 2000::/3 via ::$RELAY dev tun6to4
	#echo "before start_radvd OK.">/dev/console
    [ "`uci -q get ipv6.lan.radvd_en`" -eq 1 ] && start_radvd
	#echo "start_radvd OK.">/dev/console
	
	#set LAN IPv6 IP
	LAN_IPv6=$(uci -q get ipv6.lan.global_addr)
	if [ $LAN_IPv6 ]; then
		ifconfig br-lan $LAN_IPv6/64
	fi
  fi
}

stop_6to4()
{
  if [ "$(ip tunnel show|grep ^tun6to4)" ]; then
    ip tunnel del tun6to4
    ip -6 route del 2000::/3 2>/dev/null
    for IP in $(ip -6 addr show dev $LAN | awk '/inet6 2002/ {print $2}'); do
      ip -6 addr del $IP dev $LAN
    done
  fi
}
check_before_start()
{
  # exit if WAN IP and RELAY IP keep unchanged
  OLD_WANIP=$(ip tunnel show|grep ^tun6to4|awk '{print $6}')
  if [ "$OLD_WANIP" ]; then
    OLD_RELAY=$(ip -6 route show dev tun6to4|grep ^2000::/3|awk '{print $3}'|sed 's/:://')
    [ "$WANIP" = "$OLD_WANIP" ] && [ "$RELAY" = "$OLD_RELAY" ] && exit 1
  fi
}
waiting_for_lan_prefix()
{
  TIMEOUT=15    # second
  while [ $TIMEOUT -ge 0 ]; do
    sleep 1
    PREFIXES=$(ifconfig tun6to4 | grep "inet6 addr" | grep -v -E "fe80::|/128" | sed -e "s/^.*inet6 addr: //" -e "s/ Scope.*\$//")
	#echo "***********waiting_for_lan_prefix():$TIMEOUT $PREFIXES">/dev/console	
    [ $PREFIXES ] && break
    TIMEOUT=`expr $TIMEOUT - 1`
  done
}
# program entry

case $1 in
  "start")
    WAN=$(route -n | grep ^0.0.0.0 | awk '{print $8}')
    WANIP=$(ip -4 addr show dev $WAN | awk '/inet / {print $2}' | sed 's/\/.*//')
    RELAY=$(uci -q get ipv6.wan_6to4.v6to4_relay_route_addr)
    LOOP=1
	[ -z $RELAY ] && RELAY=192.88.99.1
	while [ $LOOP -ge 0 ]; do
		#echo "in 6to4.sh start**************** $WAN     $WANIP">/dev/console
		#check_before_start
		#echo "ready to enter stop_6to4">/dev/console
		stop_6to4
		#echo "ready to enter start_6to4">/dev/console
		start_6to4 && waiting_for_lan_prefix
		[ $PREFIXES ] && exit 0
		LOOP=`expr $LOOP - 1`
	done
	;;
  "stop")
    stop_6to4
    ;;

  *)usage
    ;;
esac
