#!/bin/sh
SERVICE=`uci -q get usbip.@usb-sharing[0].enable`
PORT1_EN=`uci -q get usbip.@usb-sharing[0].port1`
PORT2_EN=`uci -q get usbip.@usb-sharing[0].port2`

NUM_DEVICE=`usbip_bind_driver -l | awk '/busid/' | awk END'{print NR}'`

NEW_2130=`grep 'Vendor=05e3 ProdID=0608' /proc/bus/usb/devices`

RET=""
#Vendor=05e3 ProdID=0608
RET=$(ps | grep "usbipd -D" | grep -v "grep")
if [ "$SERVICE" -eq 1 ]; then
	if [ -z "$RET" ]; then
		`usbipd -D`
	fi
else
	if [ -n "$RET" ]; then
		kill $(echo $RET|awk '{ print $1; }')
		
		for i in `seq 1 ${NUM_DEVICE}`;do
			BUSID=`usbip_bind_driver -l | awk '/busid/' | awk '{if(NR=='$i')print $3}'`
			RET=`usbip_bind_driver -l | grep ${BUSID}'.*-> usbip'`
			
			if [ -n "$RET" ]; then
				RET=`usbip_bind_driver -o ${BUSID}`
			fi
		done
	fi
fi

RET=$(ps | grep "usbipd -D" | grep -v "grep")
if [ -n "$RET" ]; then
	SERVICE=1
else
	SERVICE=0
fi

if [ "$SERVICE" -ne 1 ]; then
	exit
fi

for i in `seq 1 ${NUM_DEVICE}`;do
	BUSID=`usbip_bind_driver -l | awk '/busid/' | awk '{if(NR=='$i')print $3}'`
	if [ -z "$NEW_2130" ]; then
		RET=`echo ${BUSID} | grep '1-1'`
	else
		RET=`echo ${BUSID} | grep '1-1.2'`
	fi
	if [ -n "$RET" -a -n "$PORT1_EN" ]; then
		RET=`usbip_bind_driver -l | grep ${BUSID}'.*-> usbip'`
		if [ "$PORT1_EN" -eq 1 ]; then
			if [ -z "$RET" ]; then
				RET=`usbip_bind_driver -u ${BUSID}`
			fi
		else
			if [ -n "$RET" ]; then
				RET=`usbip_bind_driver -o ${BUSID}`
			fi
		fi
	fi
	
	if [ -z "$NEW_2130" ]; then
		RET=`echo ${BUSID} | grep '1-2'`
	else
		RET=`echo ${BUSID} | grep '1-1.3'`
	fi
	if [ -n "$RET" -a -n "$PORT2_EN" ]; then
		RET=`usbip_bind_driver -l | grep ${BUSID}'.*-> usbip'`
		if [ "$PORT2_EN" -eq 1 ]; then
			if [ -z "$RET" ]; then
				RET=`usbip_bind_driver -u ${BUSID}`
			fi
		else
			if [ -n "$RET" ]; then
				RET=`usbip_bind_driver -o ${BUSID}`
			fi
		fi
	fi
done


uci -q set usbip.@usb-sharing[0].enable="$SERVICE"
uci commit usbip

