#!/bin/sh

#this script is use to setup ipv6 wan ip via dhcpv6

WAN_IF=$(uci get ipv6.wan.ifname)
WAN_LINK_ADDR=$(uci get ipv6.wan.link_addr)
WAN_MAC_ADDR=$(uci get ipv6.wan.mac_addr)
#DNS_FLAG=$(uci get ipv6.wan_dhcp.user_dhcp)
#WAN_PREFIX=$(uci get ipv6.wan_static.prefix)
#WAN_GATEWAY=$(uci get ipv6.wan_static.gateway)

WAN_DNS1=$(uci get ipv6.wan_dhcp.dns1)
WAN_DNS2=$(uci get ipv6.wan_dhcp.dns2)

killall wide-dhcp6c

if [ ! "$WAN_IF" ]; then
	echo "Interface not set"
	exit 1
fi

rm -rf /etc/dhcp6/dhcp6c_ia.conf

echo "interface $WAN_IF {                                       " > /etc/dhcp6/dhcp6c_ia.conf
echo "    send ia-na 0;                                        " >> /etc/dhcp6/dhcp6c_ia.conf
echo "    script \"/etc/dhcp6/dhcp6c-script\";                 " >> /etc/dhcp6/dhcp6c_ia.conf
echo "    request domain-name-servers,domain-name;             " >> /etc/dhcp6/dhcp6c_ia.conf
echo "};                                                       " >> /etc/dhcp6/dhcp6c_ia.conf
echo "                                                         " >> /etc/dhcp6/dhcp6c_ia.conf
echo "id-assoc na 0 {                                          " >> /etc/dhcp6/dhcp6c_ia.conf
echo "};                                                       " >> /etc/dhcp6/dhcp6c_ia.conf
#echo "    link_local_addr             $WAN_LINK_ADDR           " >> /etc/dhcp6/dhcp6c.conf
#echo "                                                         " >> /etc/dhcp6/dhcp6c.conf
#echo "    preferred_ipv6_address      2001::0323               " >> /etc/dhcp6/dhcp6c.conf
#echo "    preferred_lifetime          3600                     " >> /etc/dhcp6/dhcp6c.conf
#echo "    valid_lifetime              3600                     " >> /etc/dhcp6/dhcp6c.conf
#echo "}                                                        " >> /etc/dhcp6/dhcp6c.conf

echo "wide-dhcp6c -c /etc/dhcp6/dhcp6c_ia.conf -p /var/run/dhcp6c.pid $WAN_IF"
wide-dhcp6c -c /etc/dhcp6/dhcp6c_ia.conf -p /var/run/dhcp6c.pid $WAN_IF &

echo "user set DNS"
if [ $WAN_DNS1 ]; then
	echo "nameserver $WAN_DNS1" >> /etc/resolv.conf
fi
if [ $WAN_DNS2 ]; then
	echo "nameserver $WAN_DNS2" >> /etc/resolv.conf
fi
