#!/bin/sh
#this script is use to setup ipv6 wan ip via dhcpv6


#step 2. add related file
# UUID file
if [ ! -d /var/db/ ]; then
	mkdir /var/db
fi
	
LAN_IF=$(uci -q get ipv6.lan.ifname)
#LAN_LINK_ADDR=$(uci -q get ipv6.lan.link_addr)
#LAN_MAC_ADDR=$(uci -q get ipv6.lan.mac_addr)
LAN_ADDR_START=$(uci -q get ipv6.lan_dhcp.start_addr)
LAN_ADDR_END=$(uci -q get ipv6.lan_dhcp.end_addr)
#PREFIX=$(uci -q get ipv6.lan.prefix_len)
#PREFIX_LEN=$(uci -q get ipv6.lan.prefix_len)

if [ "$LAN_IF" ]; then
    ifconfig $LAN_IF down
    ifconfig $LAN_IF up
else
	echo "Interface not set"
	exit 1
fi

rm -rf /etc/dhcp6/dhcp6d.conf

echo "interface $LAN_IF {" 					>> /etc/dhcp6/dhcp6d.conf
echo "    address-pool mynetwork 3600; " 	>> /etc/dhcp6/dhcp6d.conf
echo " };" 									>> /etc/dhcp6/dhcp6d.conf
echo " "					 				>> /etc/dhcp6/dhcp6d.conf
echo "pool mynetwork {" 					>> /etc/dhcp6/dhcp6d.conf
echo "     range $LAN_ADDR_START to $LAN_ADDR_END;" >> /etc/dhcp6/dhcp6d.conf
echo "};                                              " >> /etc/dhcp6/dhcp6d.conf

wide-dhcp6s -c /etc/dhcp6/dhcp6d.conf -d $LAN_IF &
