#!/bin/sh

NETBIOS_NAME=$1
IP_ADDRESS=$2
FILE="/tmp/nbs"
TEMP="/tmp/nbs.tmp"
LOCK_FILE="/tmp/lock/nbs.lock"

grep -q "$IP_ADDRESS $NETBIOS_NAME" $FILE && return

TOTAL=`ps | grep -c "netbios.sh" || echo 0`

if [ $TOTAL -gt 5 ]; then
    exit 0
fi

touch $FILE 
lock $LOCK_FILE
FOUND=`echo "$IP_ADDRESS $NETBIOS_NAME"`
cat $FILE | grep -q -E "\<$FOUND\>"

if [ $? -ne 0 ]; then
    cat $FILE | grep -q -E "\<$IP_ADDRESS\>"
     
    if [ $? -eq 0 ]; then
        REPLICATE=`cat $FILE | grep -E "\<$IP_ADDRESS\>"`
        cat $FILE | sed "s/$REPLICATE/$IP_ADDRESS $NETBIOS_NAME/" > $TEMP
        cp $TEMP $FILE  
    else
        echo "$IP_ADDRESS $NETBIOS_NAME" >> $FILE
    fi

fi

sort -u $FILE > $TEMP 0>/dev/null
cp $TEMP $FILE

lock -u $LOCK_FILE


