#set_3g_led() {
	#grep WRT54G3G /proc/diag/model >/dev/null || return 0
	#echo "$1" > /proc/diag/led/3g_green
	#echo "$2" > /proc/diag/led/3g_blue
	#echo "$3" > /proc/diag/led/3g_blink
#}

#scan_3g() {
	#local device

	#scan_ppp "$@"
	#config_get device "$1" device

	## try to figure out the device if it's invalid
	#[ -n "$device" -a -e "$device" ] || {
	#	for device in /dev/ttyUSB0 /dev/ttyUSB1 /dev/ttyUSB2 /dev/ttyHS0 /dev/tts/2 /dev/usb/tts/0 /dev/noz0; do
	#		[ -e "$device" ] && {
	#			config_set "$1" device "$device"
	#			break
	#		}
	#	done
	#}

	# enable 3G with the 3G button by default
	#config_get button "$1" button
	#[ -z "$button" ] && {
	#	config_set "$1" button 1
	#}
#}

stop_interface_3g() {
	#set_3g_led 0 0 0
	killall gcom >/dev/null 2>/dev/null
}

setup_interface_3g() {
	local iface="$1"
	local config="$2"
	local chat="/etc/chatscripts/3g.chat"
	
	local dialnum=$(uci -q -P /var/state get network.${config}_dialnum)
	
	[ "$dialnum" -ge "3" ] && {
		logger -p 160.5 "==== ppp dial fail for 3 times, reset usb modem !!! "
		local usbport=$(uci -q -P /var/state get network.${config}_port)
		[ -n $usbport ] && reset_usb $(expr $usbport + 1)
		uci -q -P /var/state revert network.${config}_dialnum
		return
	}	
	
	config_get device "$config" device
	config_get maxwait "$config" maxwait
	maxwait=${maxwait:-0}
	while [ ! -e "$device" -a $maxwait -gt 0 ];do # wait for driver loading to catch up
		maxwait=$(($maxwait - 1))
		sleep 1
	done

	#for module in slhc ppp_generic ppp_async; do
	#	/sbin/insmod $module 2>&- >&-
	#done

	config_get apn "$config" apn
	config_get service "$config" service
	config_get pincode "$config" pincode
	config_get mtu "$config" mtu
	config_get is_56k "$config" is_56k
	
	config_get init_string1 "$config" init_string1
	config_get init_string2 "$config" init_string2
	config_get dial_string "$config" dial_string
	export -n -- "HSDPA_INIT_STRING1=${init_string1:-"AT&F"}"
	export -n -- "HSDPA_INIT_STRING2=${init_string2:-"ATE0V1X1&D2&C1S0=0"}"
	export -n -- "HSDPA_DIAL_STRING=${dial_string:-"ATD*99***1#"}"
	#logger -p 160.5 "====> apn=$apn, pincode=$pincode, init_string1=$init_string1"
	
	#set_3g_led 1 0 1
	
	# figure out hardware specific commands for the card
	case "$service" in
		cdma|evdo) chat="/etc/chatscripts/evdo.chat";;
	*)
		cardinfo=$(gcom -d "$device" -s /etc/gcom/getcardinfo.gcom | tr  [\\r\\n] [\ \*])
		[ -z "$cardinfo" ] && cardinfo=$(gcom -d "$device" -s /etc/gcom/getcardinfo.gcom | tr  [\\r\\n] [\ \*])
		[ $(echo "$cardinfo" | grep -c "Can't open device") == "1"  ] && {
			#/etc/gcom/3g.reboot
			uci -q -P /var/state revert network.$config.device
			logger -p 160.5 -t wan.3g "##### Can't open device $device when dial $config"
			uci -q -P /var/state revert network.$config.ifup_running
			exit 1
		}
		logger -p 160.5 -t wan.3g "##### Try to dial Modem in $config $device: $cardinfo" 

		if echo "$cardinfo" | grep Novatel; then
			case "$service" in
				umts_only) CODE=2;;
				gprs_only) CODE=1;;
				*) CODE=0;;
			esac
			mode="AT\$NWRAT=${CODE},2"
		elif echo "$cardinfo" | grep Option; then
			case "$service" in
				umts_only) CODE=1;;
				gprs_only) CODE=0;;
				*) CODE=3;;
			esac
			if [ "$device" != "/dev/ttyHS0" ]; then	# for hso driver, do not do this, nancy
				mode="AT_OPSYS=${CODE}"
			fi
		fi
		# Don't assume Option to be default as it breaks with Huawei Cards/Sticks
		
		if [ "$pincode" == "" ]; then
			ERR=0
		else
			PINCODE="$pincode" gcom -d "$device" -s /etc/gcom/setpin.gcom > /dev/null 2>&1 || {
				ERR=$?
				#echo "$config(3g): Please check your SIM card and PIN code setting."
				#set_3g_led 0 0 0
				#return 1
				#ERR=1
			}
		fi
		
		test -z "$mode" || {
			logger -p 160.5 -t wan.3g "mode = $mode......................"
			MODE="$mode" gcom -d "$device" -s /etc/gcom/setmode.gcom
		}

		if [ "$config" == "wan" ]; then
			INUSE=$(uci -q -P /var/state get network.3gdev1)
			state3g="/var/state/3g"
		else
			INUSE=$(uci -q -P /var/state get network.3gdev2)
			state3g="/var/state/3g2"
		fi		
		INUSE=${INUSE:-xxxx/xxxx/x}
		# 3gdev for WUI check if modem exist
		uci -q -P /var/state revert network.3gdev
		uci -q -P /var/state set network.3gdev=$INUSE
		
		logger -p 160.5 -t wan.3g "Bring up $config 3G INUSE = $INUSE....."
		
		[ "$is_56k" != "1" ] && {
			# fanny : for web display information
			SIG=$(gcom -d $device -s /etc/gcom/getstrength.gcom | grep +CSQ: | awk '{print $2}')
			[ -z "$SIG" ] && SIG=$(gcom -d $device -s /etc/gcom/getstrength.gcom | grep +CSQ: | awk '{print $2}')
			logger -p 160.5 -t wan.3g "Signal Strength SIG=$SIG"	
		}
		rm -f $state3g >/dev/null
		echo "==3G Card Info== :"> $state3g
		echo "$cardinfo" | grep "Manufacturer:" | awk -F* '{print $2$3}' >> $state3g
		echo "==3G Signal Strength== :">> $state3g
		echo "Signal Quality: $SIG">> $state3g
		if [ "$ERR" == "1" ]; then
			echo "==3G Error== :">> $state3g
			echo "Please check your SIM card and PIN code setting.">> $state3g
			# Not 56K and 3G error so return directly.
			if [ "$INUSE" != "0572/1329/0" -a "$INUSE" != "0403/6001/0" ]; then
				logger -p 160.5 -t wan.3g "3G error interface=$config . Check SIM card and PIN code setting."
				return 1
			fi
		elif [ "$ERR" == "2" ]; then
			logger -p 160.5 -t wan.3g "Set PIN timeout but can go on!"
		fi
		
		#step2: check if 3G device existed
		if [ "$device" != "" ]; then
			if [ "$SIG" != "" ]; then
				# If signal strength string exist already, grep directly. Reduce 2 seconds or so.
				TEST_DEV=$(echo "$SIG" | grep "Can't open device")
			else
				TEST_DEV=$(gcom -d $device sig | grep "Can't open device")
			fi
		else
			TEST_DEV=$(gcom | grep "Unable to locate default")
		fi

		if [ "$TEST_DEV" != "" ]; then
			logger -p 160.5 -t wan.3g  "3G device not exist........."
			uci -q -P /var/state revert network.$config.ifup_running
			exit 1
		fi

		# fanny : If you are here, there must be 3G device exist.
		#INUSE=$(uci -q -P /var/state get network.3gdev)
		#if [ "$INUSE" == "" ]; then
		#	uci -q -P /var/state set network.3gdev=xxxx/xxxx/x
		#fi
		
		#if user do not set APN name. ex:56K modem
		if [ "$apn" == "" -o "$is_56k" == "1" ]; then
			logger -p 160.5 -t wan.3g "Chat without APN name."
			chat="/etc/chatscripts/56k.chat"
		fi
	esac
	#set_3g_led 1 0 0

	if [ "$config" == "3gwan" ]; then
		ifnum="1"
	else
		ifnum="0"
	fi

	# hso driver
	if [ "$device" = "/dev/ttyHS0" ]; then
		lock "/var/lock/3g-hso"
		hso_output="/var/hso_connect_output_temp"
		hso_init_script="/etc/chatscripts/3g_hso_init.chat"
		hso_dial_script="/etc/chatscripts/3g_hso_dial.chat"

		hso_if="ppp"$ifnum

		logger -p 160.5 -t wan.3g "Hso : Start connecting"
		if [ "$apn" != "" ]; then
			( USE_APN=$apn /usr/sbin/chat -E -s -V -f $hso_init_script <$device >$device ) 2> $hso_output
			temp1=`grep "ERROR" $hso_output`
			temp2=`grep "CME" $hso_output`
			if [ -n "$temp1" -o -n "$temp2" ]; then
				logger -p 160.5 -t wan.3g "Hso : Failed to initialize connection but still go on..."
				cat $hso_output
				rm -f $hso_output
				#lock -u "/var/lock/3g-hso"
				#exit 0
			fi
			sleep 2
		fi
		
		hso_pip=""
		hso_counter=""
		while [ -z "$hso_pip" -a "$hso_counter" != "-----" ]
		do
			rm -f $hso_output
			hso_counter2=""
			logger -p 160.5 -t wan.3g "Hso : Start init modem"
			( /usr/sbin/chat -E -s -V -f $hso_dial_script <$device > $device ) 2> $hso_output
			sleep 2
			
			while [ -z "$hso_pip" -a "$hso_counter2" != "---" ]
			do
				logger -p 160.5 -t wan.3g "Hso : Get ip, device=$device"

				gcom -d "$device" -s /etc/gcom/hso_getip.gcom > $hso_output 2>&1
				temp1=`grep "ERROR" "$hso_output"`
				if [ -z "$temp1" ]; then
					cat $hso_output
					hso_pip=`grep "^_OWANDATA" $hso_output | cut -d, -f2`
					hso_ns1=`grep "^_OWANDATA" $hso_output | cut -d, -f4`
					hso_ns2=`grep "^_OWANDATA" $hso_output | cut -d, -f5`
				fi
				
				if [ -z "$hso_pip" ]; then
					sleep 2
				fi
				hso_counter2="${hso_counter2}-"
			done
			hso_counter="${hso_counter}-"
		done

		if [ -z "$hso_pip" ]; then
			logger -p 160.5 -t wan.3g "Hso : Failed to get ip"
			cat $hso_output
			rm -f $hso_output
			lock -u "/var/lock/3g-hso"
			exit 0
		fi

		logger -p 160.5 -t wan.3g "Hso : Setting IP address to $hso_pip"
		if [ -n "$mtu" ]; then
			ifconfig $hso_if mtu $mtu
		fi
		ifconfig $hso_if $hso_pip netmask 255.255.255.255 up
		route del default
		route add default dev $hso_if
		mv -f /etc/resolv.conf /tmp/resolv.conf.hso
		echo "nameserver	$hso_ns1" > $hso_output
		echo "nameserver	$hso_ns2" >> $hso_output
		mv $hso_output /etc/resolv.conf
		# web online status would reference this file
		cp /etc/resolv.conf /tmp/resolv.conf.auto

		set_interface_ifname "$config" "$hso_if"

		# The next line would make firewall work.
		env -i ACTION="ifup" INTERFACE="$config" DEVICE="$iface" PROTO=3g /sbin/hotplug-call "iface" &
		logger -p 160.5 -t wan.3g "3g.sh hso : Done"
		lock -u "/var/lock/3g-hso"
		exit 0
	fi

	config_set "$config" unit "$ifnum"
	config_set "$config" ifname "ppp$ifnum"
	set_interface_ifname "$config" "ppp$ifnum"

	config_set "$config" "connect" "${apn:+USE_APN=$apn }/usr/sbin/chat -t5 -v -E -f $chat"
	now=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
	uci -q -P /var/state revert network.$config.ifup_running
	uci -q -P /var/state set network.$config.ifup_running=$now
	let dialnum=dialnum+1
	uci -q -P /var/state revert network.${config}_dialnum
	uci -q -P /var/state set network.${config}_dialnum=$dialnum
	logger -p 160.5 -t wan.3g "============= Start pppd for $config #$dialnum"
	start_pppd "$config" \
		noaccomp \
		nopcomp \
		novj \
		debug \
		ipcp-max-configure 20 \
		ipcp-max-failure 20 \
		nobsdcomp \
		noauth \
		lock \
		crtscts \
		${mtu:+mtu $mtu mru $mtu} \
		115200 "$device"
}
