#include <stdio.h>
#include <string.h>
#include "./usb.h"
#include <errno.h>
#include   <time.h> 
#include <syslog.h>

/*
* Temper.c by Robert Kavaler (c) 2009 (relavak.com)
* All rights reserved.
*
* Temper driver for linux. This program can be compiled either as a library
* or as a standalone program (-DUNIT_TEST). The driver will work with some
* TEMPer usb devices from RDing (www.PCsensor.com).
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
* 
* THIS SOFTWARE IS PROVIDED BY Robert Kavaler ''AS IS'' AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL Robert kavaler BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
*/

#include "gotemp.h"

#define VENDOR_ID  0x1130
#define PRODUCT_ID 0x660c


#ifdef UNIT_TEST

#define USB_TIMEOUT 1000	/* milliseconds */
void StdformatLocalTime(char *pch)
{
	char year[5],month[3],day[3],hour[3],minute[3],secend[3],zero[5];
	struct tm *local;
	//NEMOLOG(stdout,"StdformatLocalTime");

	time_t t;
	t=time(NULL);
	local=localtime(&t);

	snprintf(pch,20,"%d-%02d-%02d %02d:%02d:%02d",local->tm_year+1900,local->tm_mon+1,local->tm_mday,local->tm_hour,local->tm_min,local->tm_sec);

}
int Readldusb(int *tempc)
{
	FILE *fRead;
	const  char *bufcmd="dd count=1 bs=8 if=/dev/ldusb0 |hexdump -d|grep -v records|awk '{print $3}'";
	char bufproc[20];
	int ret = 0;
	if((fRead=popen(bufcmd,"r"))!= NULL) 
	{ 
		if(fgets(bufproc,20,fRead)!=NULL)
		{ 
			if(atoi(bufproc)>-10000 && atoi(bufproc)<20000)
			{	
				*tempc =  atoi(bufproc); 
				ret = 1;
			}
			else
			{	
				printf("temper err\r\n");   
			}
		} 
		pclose(fRead); 
	}
	return ret;
}
int main(int argc, char* argv[]) 
{
	char buf[256],timenow[30],timelast[30],ena[300],*tmp,tmp1[100],warnlog[2000];
	int i, ret,count,unit,syslogen,mailen,smsen,smsprof,ulimit,llimit;
	float tempc,hight=0,lowt=100,avet,tmpc,cal=0;
	FILE *fp;

	//printf("test temper\n");
	//return 0;
	system("rm /tmp/usbtemperrange.log /tmp/usbtempergraph.log");
	fp=fopen("/etc/config/usb_temper","r");
	if(!fp)
		return 0;
	fread(ena,290,1,fp);
	//printf("ena=%s\n",ena);
	fclose(fp);
	if(!strstr(ena,"option enable\t'1'"))
		return 0;

	tmp=strstr(ena,"option temper_unit");
	sscanf(tmp,"option ulimit\t'%[0-9]'%*",tmp1);
	//printf("temper_unit is %s\n",tmp1);
	unit=atoi(tmp1);

	tmp=strstr(ena,"option syslong_en");
	sscanf(tmp,"option syslong_en\t'%[0-9]'%*",tmp1);
	//printf("syslong_en is %s\n",tmp1);
	syslogen=atoi(tmp1);

	tmp=strstr(ena,"option mail_en");
	sscanf(tmp,"option mail_en\t'%[0-9]'%*",tmp1);
	//printf("mail_en is %s\n",tmp1);
	mailen=atoi(tmp1);

	tmp=strstr(ena,"option sms_en");
	sscanf(tmp,"option sms_en\t'%[0-9]'%*",tmp1);
	printf("sms_en is %s\n",tmp1);
	smsen=atoi(tmp1);

	tmp=strstr(ena,"option sms_profile");
	sscanf(tmp,"option sms_profile\t'%[0-9]'%*",tmp1);
	printf("sms_profile is %s\n",tmp1);
	smsprof=atoi(tmp1);

	tmp=strstr(ena,"option ulimit");
	sscanf(tmp,"option ulimit\t'%[0-9]'%*",tmp1);
	//printf("ulimit is %s\n",tmp1);
	ulimit=atoi(tmp1);

	tmp=strstr(ena,"option llimit");
	sscanf(tmp,"option llimit\t'%[0-9]'%*",tmp1);
	//printf("llimit is %s\n",tmp1);
	llimit=atoi(tmp1);

	tmp=strstr(ena,"option cal");
	sscanf(tmp,"option cal\t'%[0-9.-]'",tmp1);
	//printf("cal is %s\n",tmp1);
	cal=atof(tmp1);

	/*	TemperSendCommand(t, 10, 11, 12, 13, 0, 0, 2, 0);
	TemperSendCommand(t, 0x43, 0, 0, 0, 0, 0, 0, 0);
	TemperSendCommand(t, 0, 0, 0, 0, 0, 0, 0, 0);
	TemperSendCommand(t, 0, 0, 0, 0, 0, 0, 0, 0);
	TemperSendCommand(t, 0, 0, 0, 0, 0, 0, 0, 0);
	TemperSendCommand(t, 0, 0, 0, 0, 0, 0, 0, 0);
	TemperSendCommand(t, 0, 0, 0, 0, 0, 0, 0, 0);
	TemperSendCommand(t, 0, 0, 0, 0, 0, 0, 0, 0);
	*/


	for(count=0;;) {

		bzero(buf, 256);

		//printf("Other Stuff (%d bytes):\n", ret);
		for(i = 0; i < ret; i++) {
			//printf(" %02x", buf[i] & 0xFF);
			if(i % 16 == 15) {
				//printf("\n");
			}
		}
		//printf("\n");

		StdformatLocalTime(timenow);
		if(strncmp(timelast,timenow,16))
		{
			//printf("timenow=%s\n",timenow);
			strcpy(timelast,timenow);
			int nTempc;
			ret = Readldusb(&nTempc);
			if(!ret)
			{
				printf("read err \n");
				sleep(1);
				continue;
			}
			tempc = (float)nTempc;
			printf("tempc %.2f\r\n", tempc);
			tempc = tempc/126.74 - 5.4;
			printf("cal %.2f\r\n", tempc);
			hight=tempc>hight?tempc:hight;
			lowt=tempc<lowt?tempc:lowt;

			avet=count?(avet*count+tempc)/(count+1):tempc;

			fp=fopen("/tmp/usbtemperrange.log","w+b");
			fprintf(fp,"%.2f,%.2f\n%.2f,%.2f\n%.2f,%.2f\n%.2f,%.2f\n",tempc, (9.0 / 5.0 * tempc + 32.0),
				hight,(9.0 / 5.0 * hight + 32.0),lowt,(9.0 / 5.0 * lowt + 32.0),avet,(9.0 / 5.0 * avet + 32.0));
			fclose(fp);

			fp=fopen("/tmp/usbtempergraph.log","a+b");
			fprintf(fp,"%.2f,%.2f\n",
				tempc, (9.0 / 5.0 * tempc + 32.0));
			fclose(fp);

			//printf("temperature %.2fC %.2fF\n",
			//       tempc, (9.0 / 5.0 * tempc + 32.0));

			if(syslogen)
				syslog(LOG_INFO, "temperature %.2fC %.2fF\n",
				tempc, (9.0 / 5.0 * tempc + 32.0));
			tmpc=unit?(9.0 / 5.0 * tempc + 32.0):tempc;

			if(tmpc+cal>=ulimit)
			{
				sprintf(warnlog," The current temperature is %.2f %c, which is out of the specified normal range (%d ~ %d %c)!!\n",
					tmpc+cal,unit?'F':'C',llimit,ulimit,unit?'F':'C');
				//fprintf(stdout," The current temperature is %.2f %c, which is out of the specified normal range (%d ~ %d %c)!!\n",
				//	tmpc+cal,unit?'F':'C',llimit,ulimit,unit?'F':'C');
				syslog(LOG_WARNING, "[alarm] temperature %.2f %c\n",tmpc+cal, unit?'F':'C');
				if(mailen)
				{			
					fp=fopen("/tmp/temper_mail_body","w+b");
					if(fp){
						fprintf(fp,"%s",warnlog);
						fclose(fp);
						system("/sbin/temper_mail_alert.sh &");
					}
				}
				if(smsen)
				{
					sprintf(warnlog,"/usr/lib/ddns/sms_updater.sh \"%d\" \"The+current+temperature+is+%.2f+%c,+which+is+out+of+the+specified+normal+range+(%d+~+%d+%c)!! &\"",
						smsprof,tmpc+cal,unit?'F':'C',llimit,ulimit,unit?'F':'C');
					printf("%s",warnlog);
					system(warnlog);
				}
			}
			if(tmpc+cal<=llimit)
			{
				sprintf(warnlog," The current temperature is %.2f %c, which is out of the specified normal range (%d ~ %d %c)!!\n",
					tmpc+cal,unit?'F':'C',llimit,ulimit,unit?'F':'C');
				//fprintf(stdout," The current temperature is %.2f %c, which is out of the specified normal range (%d ~ %d %c)!!\n",
				//	tmpc+cal,unit?'F':'C',llimit,ulimit,unit?'F':'C');
				syslog(LOG_WARNING, "[alarm] temperature %.2f %c\n",tmpc+cal, unit?'F':'C');
				if(mailen)
				{			
					fp=fopen("/tmp/temper_mail_body","w+b");
					if(fp){
						fprintf(fp,"%s",warnlog);
						fclose(fp);
						system("/sbin/temper_mail_alert.sh &");
					}
				}

				if(smsen)
				{
					sprintf(warnlog,"/usr/lib/ddns/sms_updater.sh \"%d\" \"The+current+temperature+is+%.2f+%c,+which+is+out+of+the+specified+normal+range+(%d+~+%d+%c)!! &\"",
						smsprof,tmpc+cal,unit?'F':'C',llimit,ulimit,unit?'F':'C');
					printf("%s",warnlog);
					system(warnlog);
				}
			}
			fp=fopen("/etc/config/usb_temper","r");
			if(!fp)
				continue;
			fread(ena,190,1,fp);
			//printf("ena=%s\n",ena);
			fclose(fp);

			tmp=strstr(ena,"option temper_unit");
			sscanf(tmp,"option temper_unit\t'%[0-9]'%*",tmp1);
			//printf("temper_unit is %s\n",tmp1);
			unit=atoi(tmp1);

			tmp=strstr(ena,"option syslong_en");
			sscanf(tmp,"option syslong_en\t'%[0-9]'%*",tmp1);
			//printf("syslong_en is %s\n",tmp1);
			syslogen=atoi(tmp1);

			tmp=strstr(ena,"option mail_en");
			sscanf(tmp,"option mail_en\t'%[0-9]'%*",tmp1);
			//printf("mail_en is %s\n",tmp1);
			mailen=atoi(tmp1);

			tmp=strstr(ena,"option ulimit");
			sscanf(tmp,"option ulimit\t'%[0-9]'%*",tmp1);
			//printf("ulimit is %s\n",tmp1);
			ulimit=atoi(tmp1);

			tmp=strstr(ena,"option llimit");
			sscanf(tmp,"option llimit\t'%[0-9]'%*",tmp1);
			//printf("llimit is %s\n",tmp1);
			llimit=atoi(tmp1);

			tmp=strstr(ena,"option cal");
			sscanf(tmp,"option cal\t'%[0-9.-]'",tmp1);
			//printf("cal is %s\n",tmp1);
			cal=atof(tmp1);
			//printf("cal is %f\n",cal);
			count++;
		}
		sleep(10);
	}
	return 0;
}

#endif
