#ifndef __IP_SET_TIME_H
#define __IP_SET_TIME_H

#ifdef __KERNEL__
#include <linux/list.h>
#endif
#include <linux/netfilter_ipv4/ip_set.h>
#include <linux/netfilter_ipv4/ip_set_bitmaps.h>

#define SETTYPE_NAME		"time"

#ifdef __KERNEL__
struct ip_set_time {
	struct list_head head;
	u_int32_t size;
};
#endif

enum {
	/* Match against local time (instead of UTC) */
	XT_TIME_LOCAL_TZ = 1 << 0,

	/* Shortcuts */
	XT_TIME_ALL_MONTHDAYS = 0xFFFFFFFE,
	XT_TIME_ALL_WEEKDAYS  = 0xFE,
	XT_TIME_MIN_DAYTIME   = 0,
	XT_TIME_MAX_DAYTIME   = 24 * 60 * 60 - 1,
};

struct ip_set_req_time {
	u_int32_t date_start;
	u_int32_t date_stop;
	u_int32_t daytime_start;
	u_int32_t daytime_stop;
	u_int32_t monthdays_match;
	u_int8_t weekdays_match;
	u_int8_t flags;
};

struct ip_set_req_time_create {
	u_int32_t size;
};

#ifdef __KERNEL__
struct time_list {
	struct ip_set_req_time time;
	struct list_head list;
};
extern int time_match(const struct sk_buff *skb, const void *matchinfo);
#endif

#endif /* __IP_SET_TIME_H */
