#ifndef __IP_SET_PROTOCOL_BPJM_H
#define __IP_SET_PROTOCOL_BPJM_H

#define BPJM_SERVER_PORT 5800

//error Code, must same as server side
#define SUC_QUERY             0
#define ERR_UNCATEGORIES      1
#define ERR_PAYLOAD_SIZE      2
#define ERR_REQUEST_TYPE      3
#define ERR_PROTO_VERSION     4
#define ERR_DECRYPT           5
#define ERR_TIME_STAMP        6
#define SERVER_ANNOUNCE       99

#define REQUEST_CTRL_LEN	  28
#define REQUEST_URL_LEN       256
#define REPLY_MSG_LEN         64

// wcf request packet format
typedef struct _WCF_REQUEST {
    char    RequestType;
    char    Option;
    short   TaxonomyVersion;
    char    time[6];
    char    time_stamp[16];
    short   TextLength;
    char    Text[REQUEST_URL_LEN];           
} WCF_REQUEST;

// wcf reply packet format
typedef struct _WCF_REPLY{
    char    RequestType;
    char    Option;
    short   TaxonomyVersion;
    char    RequestID[4];
    short   ReturnCode;
    short   TopicNumber;
    short   match_len;
    short   reserved;
    char    msg[REPLY_MSG_LEN];
} WCF_REPLY;

#define WCF_SET_VER_NUM(x)         (x & 0x0000000f)       // bit 0-3
#define WCF_GET_MATCH_TYPE(x)      ((x & 0x00000010)>>4)  // bit 4

struct webcategory_tm {
  int tm_sec;   /* seconds after the minute, 0 to 60
                   (0 - 60 allows for the occasional leap second) */
  int tm_min;   /* minutes after the hour, 0 to 59 */
  int tm_hour;  /* hours since midnight, 0 to 23 */
  int tm_mday;  /* day of the month, 1 to 31 */
  int tm_mon;   /* months since January, 0 to 11 */
  int tm_year;  /* years since 1900 */
  int tm_wday;  /* days since Sunday, 0 to 6 */
  int tm_yday;  /* days since January 1, 0 to 365 */
  int tm_isdst; /* Daylight Savings Time flag */
};

#endif
