#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netdb.h> 
#include <signal.h>
#include <netinet/in.h>
#include <pthread.h>
#include <time.h>
#include <linux/if.h>
#include <linux/sockios.h>
#include <linux/ethtool.h>
#include <linux/mii.h>
#include <asm-generic/fcntl.h>

#include <unistd.h> 
#include <sys/types.h>
#include <sys/signal.h>

#include <sys/wait.h>
#include <syslog.h>

//An user mode program can not include kernel header file list.h, we define struct list_head here.
struct list_head {
	struct list_head *next, * prev;
}; 

//#include "../../linux-2.6.21.x/drivers/net/lte_driver/lte_user_if.h"
#include "lte_user_if.h"

#define LTE_DAEMON_SYSLOG_DBG 1
#if LTE_DAEMON_SYSLOG_DBG == 1
#define LTE_SYSLOG(x) { syslog x;}
#else
#define LTE_SYSLOG(x) 
#endif

int devfd;

struct modem_st
{
	char	if_name[10];
	int		connected;
	unsigned char	mac[6];
	unsigned char	bssid[6];
	char	sw_ver[40];
	char	hw_ver[40];
	int		link_status;
	int		rssi;
	float	cinr;
	int		dbm;
	int		network_type;
	unsigned char	my_ip[4];
	unsigned char	dns_ip[4];
	unsigned char   dns_ip_str[30];

};

#define LTE_TIMER 1
#define LTE_LINK_DOWN_TEST 0

#if LTE_TIMER == 1
#define LTE_LINK_DOWN_TIMEOUT	 15		// wait a period to process link-down event

typedef struct _lte_t {
	int 	lte_state;		
	int		timer_start;
	int		timer_len;
} lte_t;

lte_t lte_timer = {0, 0, 0};

int lte_start_timer(int state, int timeout);
int lte_stop_timer(void);
#endif

//Note: for multiple instance driver, lte_modem should be dynamically allocated
struct modem_st lte_modem;
//----------------------------------------------------------------------------------------------
//          misc. routines
//----------------------------------------------------------------------------------------------
//#define INFO_PATH "/var/network/wimax"
#define INFO_PATH "/var/state/wimax"
static void sig_set_info(int signum)
{
//	printf("----> sighandler_set_info()\n");
	struct modem_st *modem = &lte_modem;
	int rssi, rssi_percent;
	if(!modem->connected) return;
	FILE *f = fopen(INFO_PATH, "w");
	if (f) {
		if (modem->link_status >= 1) {
			fprintf(f, "%d %02x:%02x:%02x:%02x:%02x:%02x %02x:%02x:%02x:%02x:%02x:%02x ", modem->link_status, 
				modem->bssid[0], modem->bssid[1], modem->bssid[2], modem->bssid[3], modem->bssid[4], modem->bssid[5], 
				modem->mac[0], modem->mac[1], modem->mac[2], modem->mac[3], modem->mac[4], modem->mac[5]);
			rssi = (int)modem->rssi;
			if (rssi >= 0 || rssi < -150) {		// fix overflow
				rssi = -150;
				rssi_percent = 0;
			} else {
				rssi_percent = (modem->dbm << 1) + modem->dbm + (modem->dbm >> 2);	// percentage : (dbm/31)*100
				if (rssi_percent <= 0)
					rssi_percent = 1;
				if (rssi_percent >= 100)
					rssi_percent = 99;
			}
			if ( modem->cinr < -100.0 ||  modem->cinr > 100.0)	// fix overflow
				fprintf(f, "%d --- %d", rssi, rssi_percent);
			else
				fprintf(f, "%d %2.2f %d", rssi, modem->cinr, rssi_percent);
		} else {
			fprintf(f, "%d --- --- ", modem->link_status);
			fprintf(f, "-150 --- 0");
		}

		if (strlen(modem->sw_ver) > 0){
			fprintf(f, " %s", modem->sw_ver);
		}else{
			fprintf(f, " ---");
		}
		fclose(f);
	}
//	printf("<---- sighandler_set_info()\n");
}

static max(int a, int b)
{
	if(a > b) 		
		return a;
	else
		return b;
}

static char getch(void)
{
    char ch;
    ch = getchar();
    if(ch == 0xA) return ch;   //user hit CR only 
    while(getchar() != 0xA) {} //flush all unwanted characters before LF AND LF itself   
    return ch;
}

//-------------------------- config ------------------------
#define CHUNK 256    // i think Chunk size=256 is quite enough   //bruce hsu 
static char *slurp(FILE *p)
{
    size_t off = 0, tot = CHUNK, n;
    char *buf = realloc(NULL, CHUNK+1); /* Zero terminate */
    while((n = fread(buf+off, 1, CHUNK, p)) > 0) {
        off += n, tot += n;
        buf = realloc(buf, tot);
    }
    buf[off] = '\0';  /* Zero terminate - we have room */
    return buf;
}

char *run_command(const char *cmd)
{
    FILE *p = popen(cmd, "r");
    char *buf = NULL;
    if(p) {
        buf = slurp(p);
        pclose(p);
    } else {
        perror(cmd);
    }
	if (buf && isspace(buf[strlen(buf)-1]))	// remove '0x0a' at end of buf
		buf[strlen(buf)-1] = '\0';
    return buf;
}

char * get_config_apn()
{
	//char *str = run_command("nvram_get 2860 lte_apn");
	char *str = run_command("uci -q get network.wan.lte_apn");
	return str;
}

char * get_config_pin()
{
	//char *str = run_command("nvram_get 2860 lte_pin");
	char *str = run_command("uci -q get network.wan.lte_pincode");
	return str;
}

int get_config_net_mode()
{
	int ret = 0; //default value : multi mode
	//char *str = run_command("nvram_get 2860 lte_net_mode");
	char *str = run_command("uci -q get network.wan.lte_netmode");
	if (str) {
		if(strlen(str)){
			ret = atoi(str);
		}
		free(str);		
	}
	return ret;
}

static int not_dgt(char ch)
{
    if(ch > 0x39) return 1;
    if(ch < 0x30) return 1;
    return 0;
}

static void ip_str_2_ip_char(char * str, char * buf)
{
    int i, j, k;
    char s[16];
    j = 0;

    memcpy(s, str, 16);

    j = k = 0;
    for(i = 0; i < 16; i++)
    {
        if(s[i] =='.' || not_dgt(s[i])) 
        {
            s[i] = 0;
            if(k < 4) buf[k++]= atoi(&s[j]);
            j = i +1;
        }
    }
}

static int string_found(char * str, char * buf, int len)
{
    int i;

    if(len < strlen(str)) return -1;

    for(i=0; i<(len - strlen(str)); i++)
    {
        if(strncmp(&buf[i], str, strlen(str)) == 0) 
        {
//            WIMAX_PRINT( LOG_INFO, "%s found", str);
            return i;
        }
    }
    return -1;
}

static int get_wan_dns_ip(struct modem_st *modem)
{
	char * rsp;
	int i, j;

	//get information for pinging DNS server to keey wan connected
	//rsp = run_command("cat /etc/resolv.conf | grep nameserver");
	rsp = run_command("cat /tmp/resolv.conf.auto | grep -m 1 nameserver");
    if(!rsp) return -1;;

//	printf("DNS %s\n", rsp);
	i = string_found("nameserver", rsp, strlen(rsp));
	if(i >= 0)
	{
		if(rsp[i + 11] != '0')
		{
			//we get the primaryDNS server 
			//printf("Found Primary DNS Server[ %s ]\n",  &rsp[ i + 11]);
			strcpy(lte_modem.dns_ip_str, &rsp[ i + 11]);
			ip_str_2_ip_char(&rsp[i + 11], modem->dns_ip);

		}
		else
		{
			//IP is 0.0.0.0,
			//printf("Can't find Primary DNS Server\n");
			free(rsp);
			return -1;
		}

	}
	else
	{
		free(rsp);
		return -1;
	}
	free(rsp);

	rsp = run_command("ifconfig wimax0 | grep inet");
    if(!rsp) return -1;;

//	printf("%s\n", rsp);
	i = string_found("inet addr", rsp, strlen(rsp));

	if( i >= 0)
	{
//		printf("WAN IP %s\n", &rsp[i + 10]);

	    ip_str_2_ip_char(&rsp[i + 10], modem->my_ip);
	}
	else
	{
		free(rsp);
		return -1;
	}
	free(rsp);
	return 0;
}

void parse_event(struct modem_st *modem, struct lte_event_st * event)
{
	char buf[100], *str;

	switch(event->type)
	{
		case LTE_MODEM_POWER_RECYCLE:
			//system("gpio u");
			system("echo \"clear\" > /proc/gpio/GPIOA12");
			system("echo \"clear\" > /proc/gpio/GPIOA31");
			system("echo \"set\" > /proc/gpio/GPIOA12");
			system("echo \"set\" > /proc/gpio/GPIOA31");
			break;

		case LTE_MODEM_CONNECTED:
			printf("LTE_D: modem %s connected\n", event->if_name);	
			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s connected\n", event->if_name));
			modem->connected = 1;
#if 0 //test
			system("echo 1 > /var/network/wimaxStatus2");

			modem->mac[0] = 0; modem->mac[1] = 1; modem->mac[2] = 2;
			modem->mac[3] = 3; modem->mac[4] = 4; modem->mac[5] = 5;
			modem->bssid[0] = 16; modem->bssid[1] = 17; modem->bssid[2] = 18; 
			modem->bssid[3] = 19; modem->bssid[4] = 20; modem->bssid[5] = 21;
			strcpy(modem->sw_ver, "ver-1.1.2.3");
			modem->link_status = 2;
			modem->rssi = -65;
			modem->cinr = 30;
			modem->dbm = 24;
#endif
			break;

		case LTE_MODEM_DISCONNECTED:
			printf("LTE_D: modem %s disconnected\n", event->if_name);
			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s disconnected\n", event->if_name));
			modem->connected = 0;
			strcpy(lte_modem.dns_ip_str, "");
			system("rm -f /var/network/wimax");
			system("echo 0 > /var/network/wimaxStatus2");
			//system("wimax.sh down");
			system("run_lte.sh down");
			break;

		case LTE_PACKET:
			printf("LTE_D: modem %s Rx Packet, len = %d, 0x%02X 0x%02X 0x%02X 0x%02X\n", event->if_name, event->data.packet.len,
					event->data.packet.body[0], event->data.packet.body[1], event->data.packet.body[2], 
					event->data.packet.body[3]);
			LTE_SYSLOG(("LTE_D: modem %s Rx Packet, len = %d, 0x%02X 0x%02X 0x%02X 0x%02X\n", event->if_name, event->data.packet.len,
					event->data.packet.body[0], event->data.packet.body[1], event->data.packet.body[2], 
					event->data.packet.body[3]));

			break;

		case LTE_HW_VERSION:
			printf("LTE_D: modem %s HW VER %s\n", event->if_name, event->data.hw_ver);
			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s HW VER %s\n", event->if_name, event->data.hw_ver));
			strcpy(modem->hw_ver,  event->data.hw_ver);
			break;

		case LTE_SW_VERSION:
			printf("LTE_D: modem %s SW VER %s\n", event->if_name, event->data.sw_ver);
			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s SW VER %s\n", event->if_name, event->data.sw_ver));
			strcpy(modem->sw_ver,  event->data.sw_ver);
			break;

		case LTE_MAC_ADDR:
			printf("LTE_D: modem %s MAC: %02X:%02X:%02X:%02X:%02X:%02X\n", event->if_name, event->data.mac[0],
				   event->data.mac[1], event->data.mac[2],event->data.mac[3],
				   event->data.mac[4], event->data.mac[5]);
			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s MAC: %02X:%02X:%02X:%02X:%02X:%02X\n", event->if_name, event->data.mac[0],
				   event->data.mac[1], event->data.mac[2],event->data.mac[3],
				   event->data.mac[4], event->data.mac[5]));

			memcpy(modem->mac, event->data.mac, 6);
			break;

		case LTE_BSSID:
			printf("LTE_D: modem %s BSSID: %02X:%02X:%02X:%02X:%02X:%02X\n", event->if_name, event->data.bssid[0],
				   event->data.bssid[1], event->data.bssid[2],event->data.bssid[3],
				   event->data.bssid[4], event->data.bssid[5]);

			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s BSSID: %02X:%02X:%02X:%02X:%02X:%02X\n", event->if_name, event->data.bssid[0],
				   event->data.bssid[1], event->data.bssid[2],event->data.bssid[3],
				   event->data.bssid[4], event->data.bssid[5]));
			memcpy(modem->bssid, event->data.bssid, 6);
			break;

		case LTE_LINK_UP:
			printf("LTE_D: modem %s Link Up\n", event->if_name);
			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s Link Up\n", event->if_name));
			/* Status changed so update immediately. */
			sig_set_info(SIGUSR1);
			system("echo 1 > /var/network/wimaxStatus2");
			//system("wimax.sh up");
			system("run_lte.sh up");
			#if LTE_TIMER == 1
			lte_stop_timer();
			#endif
			break;

		case LTE_LINK_DOWN: 
			printf("LTE_D: modem %s Link Down\n", event->if_name);
			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s Link Down\n", event->if_name));
			/* Status changed so update immediately. */
			sig_set_info(SIGUSR1);
			#if LTE_TIMER == 1
			lte_start_timer(LTE_LINK_DOWN, LTE_LINK_DOWN_TIMEOUT);
			#else
			strcpy(lte_modem.dns_ip_str, "");
			system("echo 0 > /var/network/wimaxStatus2");
			//system("wimax.sh down");
			system("run_lte.sh down");
			#endif
			break;

		case LTE_SET_PIN_INVALID: 
			printf("LTE_D: modem %s Set Pin Invalid\n", event->if_name);
			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s Set Pin Invalid\n", event->if_name));
			//system("nvram_set lte_pin \"Wrong PIN\"");
			//sprintf(buf, "killall -%d goahead", (SIGRTMIN+2));
			//system(buf);
			break;

		case LTE_LINK_STATUS:
			printf("LTE_D: modem %s link status = %d, RSSI = %d dmm, CINR = %d db\n", event->if_name, event->data.link_info.link_status, 
				    event->data.link_info.rssi, event->data.link_info.cinr);
			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s link status = %d, RSSI = %d dmm, CINR = %d db\n", event->if_name, event->data.link_info.link_status, 
				    event->data.link_info.rssi, event->data.link_info.cinr));
			modem->link_status = event->data.link_info.link_status;
			modem->rssi = event->data.link_info.rssi;
			modem->cinr = event->data.link_info.cinr;
			modem->dbm = event->data.link_info.dbm;
			break;

		case LTE_NETWORK_TYPE:
			modem->network_type =  event->data.network_type;
			sprintf(buf, "echo %d > /var/network/lte_cgreg", modem->network_type);
			system(buf);
			break;

		case LTE_GET_CONFIG:
			printf("LTE_D: modem %s get config\n", event->if_name);
			LTE_SYSLOG((LOG_INFO, "LTE_D: modem %s get config\n", event->if_name));
			event->data.lte_config.network_mode = get_config_net_mode();
			str = get_config_apn();
			event->data.lte_config.apn[0] = 0;
			if(str) 
			{
				strcpy(event->data.lte_config.apn, str);
				free(str);
			}

			str = get_config_pin();
			event->data.lte_config.pin[0] = 0;
			if(str) 
			{
				strcpy(event->data.lte_config.pin, str);
				free(str);
			}
			write(devfd, event, sizeof(struct lte_event_st));
			break;

		case LTE_GET_MY_DNS_IPS:
			//printf("LTE_D: modem %s get my IP and DNS IP\n", event->if_name);
#if 0 //test
			modem->my_ip[0] = 192; modem->my_ip[1] = 168; modem->my_ip[2] = 1; modem->my_ip[3] = 90;
			modem->dns_ip[0] = 168; modem->dns_ip[1] = 95; modem->dns_ip[2] = 1; modem->dns_ip[3] = 1;
#endif
			if(get_wan_dns_ip(modem) < 0)
			{
				//printf("Can not get my IP and DNS IP\n");
				return;
			}

			memcpy(event->data.ips.my_ip, modem->my_ip, 4);
			memcpy(event->data.ips.dns_ip, modem->dns_ip, 4);
			write(devfd, event, sizeof(struct lte_event_st));
			break;

		default:
			printf("LTE_D: modem %s unknown event [%d]\n", event->if_name, event->type);
	}
}

static void sig_exit(int signum)
{
	printf("LTE_D: close lte device \n");
    close(devfd);
	//system("rmmod lte_drv");
	exit(0);
}

#if LTE_LINK_DOWN_TEST == 1
#define SIGRTMIN 32
void add_link_up_event(int signum)
{
	struct lte_event_st event;

	printf("LTE_D: add_link_up_event\n");

	event.type = LTE_LINK_UP;
	parse_event(&lte_modem, &event);
}

void add_link_down_event(int signum)
{
	struct lte_event_st event;

	printf("LTE_D: add_link_down_event \n");

	event.type = LTE_LINK_DOWN;
	parse_event(&lte_modem, &event);
}
#endif

void register_signal_handle_fun()
{
	signal(SIGTERM, sig_exit);
	signal(SIGUSR1, sig_set_info);
#if LTE_LINK_DOWN_TEST == 1
	signal((SIGRTMIN+1), add_link_up_event);
	signal((SIGRTMIN+2), add_link_down_event);
#endif
}

#if LTE_TIMER == 1
int lte_start_timer(int state, int timeout)
{
	printf("LTE_D: setup link down timer=%d\n", timeout);
	lte_timer.lte_state = state;
	lte_timer.timer_start = time(NULL);
	lte_timer.timer_len = timeout;
	
	return 0;
}

int lte_stop_timer(void)
{
	printf("LTE_D: stop link down timer\n");
	lte_timer.timer_start = -1;
	
	return 0;
}

void lte_process_link_down(void)
{
	printf("LTE_D: lte_process_link_down\n");

	strcpy(lte_modem.dns_ip_str, "");
	system("echo 0 > /var/network/wimaxStatus2");
	//system("wimax.sh down");
	system("run_lte.sh down");

	lte_timer.timer_start = -1;
}

void timer_handler(int signum)
{
	unsigned int now = time(NULL);
	
	if (lte_timer.timer_start > 0) {
		if ((now - lte_timer.timer_start) >= lte_timer.timer_len) { // the timeout happened
			switch (lte_timer.lte_state) {
				case LTE_LINK_DOWN:
					lte_process_link_down();
				break;

				default:
					printf("unkonwn LTE state %d in timer_handler\n", lte_timer.lte_state);
				break;
			}
		}
	}
}
#endif

//----------------------------------------------------------------------------------------------
//          main program
//----------------------------------------------------------------------------------------------
int main(int argc, char *argv[])
{
    fd_set read_set;
    struct timeval timeout;
    int ret, max_fd, i;
    char buffer[100];
    char choice;
    struct timeval tv;
    time_t curtime;
	struct lte_event_st event;
	struct sigaction sigact;
	memset(&lte_modem, 0, sizeof(struct modem_st));
	register_signal_handle_fun();

	sprintf(buffer, "echo %d > /var/run/wimax.pid", (int)getpid());
	system(buffer);

	mkdir("/var/network/", 0644);

    gettimeofday(&tv, NULL); 
    curtime=tv.tv_sec;
    strftime(buffer,30,"%m %d  %H %M",localtime(&curtime));
 //   printf("Current Time %s, len = %d\n",buffer, strlen(buffer));

    devfd = open("/dev/LTE0", O_RDWR);
    if (devfd == -1) {
	    printf("Can't open /dev/LTE0\n");
	    return -1;
    }

    FD_ZERO(&read_set);
    
    printf("LTE modem daemon Started!\n");
	LTE_SYSLOG((LOG_INFO, "LTE_D: LTE modem daemon Started!\n"));
	
	max_fd = max(0, devfd);
    
    while(1)
    {
        timeout.tv_sec = 5;
        timeout.tv_usec = 0;
        FD_SET(devfd, &read_set);

        ret = select(max_fd+1, &read_set, 0, 0, &timeout);
        if(ret < 0)
        {
            // printf("lte_d select() error, select() return %d\n", ret);
            // Kill SIGUSR1 or other signal to this process may cause select error. 
            // Just continue and don't return -1 directly. 
            continue;
        }else{

            if(ret == 0)
            {
                //printf("lte_d select() time out!\n");
				if(strlen(lte_modem.dns_ip_str) > 0)
				{
					sprintf(buffer, "ping -c 1 -I wimax0 %s >/dev/null", lte_modem.dns_ip_str);
					printf("%s\n", buffer);
					system(buffer);
				}

            }
            else 
            {
                if(FD_ISSET(devfd, &read_set))
                {
                    FD_CLR(devfd, &read_set);
                    //while
                    while(read(devfd, &event, sizeof(struct lte_event_st)))
                    {
                       parse_event(&lte_modem, &event);
                    }
                }
           
            }//if(ret == 0)
        }//if(ret < 0)

#if LTE_TIMER == 1
		timer_handler(0);	// call timer handler
#endif
    } //while(1)
    close(devfd);

	return (0);
}

