#include <linux/string.h>
#include <linux/usb.h>
#include "lte_driver.h"
#include "lte_at_cmd.h"
#include "lg_vl600_lte.h"
#include "os_shim.h"
#if LG_VL600_LTE_SUPPORT == 1

//1, self test 
#define LG_VL600_SELF_TEST 0

struct vl600_cmd_st
{
	int code;
	int len;
	int BYTE_927;
	int tail;
	int CRC_32;
};

static struct vl600_cmd_st  vl600_cmd_tbl[] =
{
	{0x7E7E,    3, 0, 0x7E7E, 0xD029F4E5},
    {0x01F1,    4, 0, 0xF1E1, 0xB4E6D0A7},
    {0xF166, 1891, 0, 0x72F4, 0x65D0D754},
    {0xF10A, 1891, 0, 0x5A6D, 0x83B2290C},
    {0xF164, 1891, 0, 0x482E, 0xEDBC743C},
    {0xF152, 1891, 0, 0xDC62, 0x1BD7A87E},
    {0xF114, 1890, 1, 0xB351, 0xE74F9917},
    {0xF10A, 1891, 0, 0x5A6D, 0x83B2290C},
    {0xF128, 1891, 0, 0x1D7C, 0xD5DA0FE9},
    {0xF101, 1891, 0, 0xA6AA, 0xDB5EEDCF},
    {0xF102, 1891, 0, 0x811D, 0x17041F13},
    {0xF100, 1891, 0, 0xBBC7, 0x9F68BC7B},
    {0xF172, 1891, 0, 0xA1A9, 0xC5D32DF3},
    {0xF151, 1891, 0, 0xFBD5, 0xD78D5AA2},
    {0xF16F, 1891, 0, 0xB4E9, 0xB550B0FF},
    {0xF171, 1891, 0, 0x861E, 0x0989DF2F},
    {0xF14D, 1891, 0, 0xF3F8, 0xE338961A},
};

int lg_vl600_at_cmd_process(struct lte_modem_st * modem, char * buf, char * at_cmd)
{
    int len, padding_len;

	//magic number
	buf[0] = 0x5A;
	buf[1] = 0x48;
	buf[2] = 0x12;
	buf[3] = 0xA5; 

	//sequence number
	buf[4] = modem->counter_1 & 0xFF;
	buf[5] = (modem->counter_1 & 0xFF00) >> 8;
	buf[6] = (modem->counter_1 & 0xFF0000) >> 16;
	buf[7] = (modem->counter_1 & 0xFF000000) >> 24;
	modem->counter_1++;

	//length of AT command string
	len = strlen(at_cmd);
	buf[8] = len & 0xFF;
	buf[9] = (len & 0xFF00) >> 8;
	buf[10] = (len & 0xFF0000) >> 16;
	buf[11] = (len & 0xFF000000) >> 24;

	//indicate AT command
    buf[12] = 0x11;
	buf[13] = 0xF0;

	//at_cmd string
	strcpy(&buf[14], at_cmd);

	//padding
	len += 14;
	padding_len = (4 - (len & 3)) & 3;
	memset(&buf[len], 0, padding_len);
    len += padding_len;
    if((len & 3) != 0) printk("Data Packet not a multiple of 4 bytes !!!!!!!!!!\n");
	return len;
}

static int lg_vl600_set_state(struct lte_modem_st * modem, unsigned char state)
{
	unsigned char buf[2];
	int act_count;

	buf[0] = state;
	buf[1] = 0;
    if((act_count = usb_control_out(modem->usb_dev, 0x02, 0x21, 0x0001, 0x0003, buf, 2, 1000)) < 0)
	{
		printk("set state not support\n");
	}

	return 0;

}

static int lg_vl600_get_state(struct lte_modem_st * modem, unsigned char * state)
{
	unsigned char buf[2];
	int act_count;

	buf[0] = buf[1] = 0xFF;
    if((act_count = usb_control_in(modem->usb_dev, 0x02, 0xA1, 0x0001, 0x0003, buf, 2, 1000)) < 0)
	{
		printk("get state not support\n");
	}
    
    lte_dump_buffer(buf, act_count, "state\n");
	* state = buf[0]; 
	return 0;

}

static int lg_vl600_send_p_cmd_sync(struct lte_modem_st * modem, int code, int len, int byte_927, int tail)
{
	int act_count;
	unsigned char * buf;
    int padding_len;

	buf = kmalloc(2048, GFP_ATOMIC);
	if(!buf)
	{
		printk("Can't get buffer in lg_vl600_send_p_cmd_sync()\n");
		return -1;
	}
    memset(buf, 0, 2048);

	//magic number
	buf[0] = 0x5A;
	buf[1] = 0x48;
	buf[2] = 0x12;
	buf[3] = 0xA5; 

	//sequence number
	buf[4] = modem->counter_2 & 0xFF;
	buf[5] = (modem->counter_2 & 0xFF00) >> 8;
	buf[6] = (modem->counter_2 & 0xFF0000) >> 16;
	buf[7] = (modem->counter_2 & 0xFF000000) >> 24;
	modem->counter_2++;

	//length of proprietary command 
	buf[8] = len & 0xFF;
	buf[9] = (len & 0xFF00) >> 8;
	buf[10] = (len & 0xFF0000) >> 16;
	buf[11] = (len & 0xFF000000) >> 24;

	//indicate proprietary command
    buf[12] = 0x21;
	buf[13] = 0xF0;

	//code
	buf[14] = (code & 0xFF00) >> 8;
	buf[15] = code & 0xFF;

    //byte 927
	buf[926] = byte_927;

	//add header length
	len += 14;  
	
	//tail
	buf[len - 3] = (tail & 0xFF00) >> 8;
	buf[len - 2] = tail & 0xFF;

	//end mark
	buf[len - 1] = 0x7E;

	//padding
	padding_len = (4 - (len & 3)) & 3;
	memset(&buf[len], 0, padding_len);
    len += padding_len;
    if((len & 3) != 0) printk("Data Packet not a multiple of 4 bytes !!!!!!!!!!\n");

	LTE_PRINT(("----- >VL600 P Command 0x%04X\n", code));
//	lte_dump_buffer(buf, len, "");
    if(usb_bulk_msg_out(modem->usb_dev, 0x05, buf, len, &act_count, 1000) < 0)
	{
		printk("send to at cmd pipe failed in lg_vl600_send_p_cmd_sync()!!!\n");
		kfree(buf);
		return -1;
	}

	kfree(buf);
	return 0;
}

static void lg_vl600_config_rx_buf(struct lte_modem_st * modem)
{
	modem->rx_buf_size = 64 * 1024; 
	modem->act_rx_buf_count = 4;
	modem->rx_head_room = 0;
	modem->rx_use_dma_buf = 1;

#if LTE_USE_PRE_ALLOC_TX_BUF == 1
	modem->tx_buf_size = 1600; 
	modem->act_tx_buf_count = modem->tx_buf_left = 128;
#endif//LTE_USE_PRE_ALLOC_TX_BUF == 1
}

extern void lte_send_ap_get_config(struct lte_modem_st * modem);
void lg_vl600_get_config(struct lte_modem_st * modem)
{
	lte_send_ap_get_config(modem);
}

void lg_vl600_report_info(struct lte_modem_st * modem)
{
	lte_send_ap_modem_connected(modem);
   	lte_send_ap_sw_ver(modem);
   	lte_send_ap_hw_ver(modem);
	lte_send_ap_mac(modem);
	lte_send_ap_bssid(modem);
	modem->network_connected = 7;
	lte_send_ap_network_type(modem);
}

void lg_vl600_lte_timer(struct lte_modem_st * modem)
{
	if(!draytek_hw) return 0;

	if((modem->counter % 5) == 0)
	{
		if(!modem->link_up)
		{
			LTE_PRINT(("connecting..........\n"));	
			lg_vl600_send_p_cmd_sync(modem, 0xF14A, 1891, 0, 0xB1F3);
		}

		//This is not working ????/
//		send_at_cmd_sync(modem, "AT+CSQ\r");
	}

	if(modem->state == 100 && modem->ready)
	{
		modem->state = 2;
		lte_link_up(modem);
	}

    if(modem->connect_timer > 0)
	{
		LTE_PRINT(("LTE connect timer = %d\n", modem->connect_timer));
		modem->connect_timer--;
		if(modem->connect_timer == 0)
		{
#if 0
			send_at_cmd_sync(modem, "ATE0V1\r");

			send_at_cmd_sync(modem, "AT+CMEE=1\r");

			send_at_cmd_sync(modem, "AT+CPIN?\r");

			send_at_cmd_sync(modem, "AT+CLCK=\"SC\",2\r");
#endif
		}

    }//if(modem->connect_timer > 0)
	return;
}



static void lg_vl600_process_frame(struct lte_modem_st * modem, char * frame, int len)
{
	int frame_len, num_of_pkt, seq_num, i, new_state;
	int packet_len, packet_len_padded;
	unsigned char * p = (unsigned char *)frame;
	unsigned short protocol;

	frame_len = p[0] | (p[1] << 8) | (p[2] << 16) | (p[3] << 24);
	seq_num = p[4] | (p[5] << 8) | (p[6] << 16) | (p[7] << 24);
	num_of_pkt = p[8] | (p[9] << 8) | (p[10] << 16) | (p[11] << 24);

//	LTE_PRINT(("--------- frame length = %d, seq num = %d, number of packet = %d ---------\n", frame_len, seq_num, num_of_pkt));

	p += 24; //move to the 1'st packet

	if(num_of_pkt > 45)
	{
		printk("too many packets in a frame, abandon whole frame !\n");
		return;
	}

	for(i = 0; i < num_of_pkt; i++)
	{
		//packet_len include packet header which is happens to be 14 bytes, the same as the ethernet header
		packet_len = 14 + (p[8] | (p[9] << 8) | (p[10] << 16) | (p[11] << 24));
		protocol = (p[12] << 8) | p[13];
		packet_len_padded = (packet_len + 3) & ~3;

//		LTE_PRINT(("protocol = 0x%04X, packet len = %d, padded len = %d\n", protocol, packet_len, packet_len_padded));

		if(packet_len > 1600)
		{
			printk("packet too long, abandon whole frame !\n");
			return;
		}

		if(packet_len < 14)
		{
			printk("packet too short, abandon whole frame !\n");
			return;
		}

		switch(protocol)
		{
		case 0x0800:
			//IP packet, fill mac addresses
			fill_modem_mac(modem, p);

			//fill magic source mac 00:f2:f3:f4:f5:f6
			p[6] = 0x00; p[7] = 0xF2; p[8] = 0xF3; p[9] = 0xF4; p[10] = 0xF5; p[11] = 0xF6;
			break;

		case 0x0806:
			//ARP packet
			p += 14;
			packet_len -= 14;
			break;

        case 0x0B06:
			//state report
			LTE_PRINT(("State Report: "));
			p += 14;
			packet_len -= 14;
			for(i = 0; i < (packet_len/4); i++)
			{
				LTE_PRINT(("0x%02X ", p[i * 4]));
			}
			LTE_PRINT(("\n"));
			new_state = p[0];

#if LG_VL600_SELF_TEST == 1
			new_state = 2;
#endif
		
			//modem state 1 ---> 8  ----> 2 (link up) ----> other than 2 (link down)
			if(new_state != modem->state)
			{
				LTE_PRINT(("modem state %d ---> %d\n", modem->state, new_state));
				if(new_state == 2)
				{
					if(modem->ready) 
					{
						lte_link_up(modem);
					}
					else
					{
						//modem is not ready yet, we delay the link up report after modem is ready
						new_state = 100;
					}
				}
				else
				{
					if(modem->state == 2) lte_link_down(modem);
				}

				modem->state = new_state;
			}
			goto next;

		default:
			printk("unknown protocol [0x%04X]\n", protocol);
			goto next;
		}

		//pass packet to network layer 
//		lte_dump_buffer(p, packet_len, "packet:\n");
		lte_netif_rx(modem, p, packet_len);

next:
		//advance to next packet
		p += packet_len_padded;
	}	
}

void lg_vl600_lte_rx_process(struct lte_modem_st * modem, char * buf, int len)
{
	unsigned char * p = (unsigned char *)buf;
	int frame_len;
	if(!draytek_hw()) return;

	if(!modem->collecting_frame)
	{
		//this is beginning of a frame, a frame contains one or more packets, packets might spread across many USB transactions
		//got to gave at least 24 bytes for frame header
		if(len < 24)
		{
			printk("buffer length less than the size of a frame header\n");
			return;
		}

		frame_len = p[0] | (p[1] << 8) | (p[2] << 16) | (p[3] << 24);

		if(len == frame_len)
		{
			//we have a complete frame in this transaction
			lg_vl600_process_frame(modem, buf, len);
		}
		else
		{
			//an incomplete frame in this transaction, initialize frame buffer stuffs to start collecting a complete frame
//			LTE_PRINT(("incomplete frame\n"));
			modem->collecting_frame = 1;
			modem->frame_len = frame_len;
			memcpy(modem->frame_buf, buf, len);
			modem->frame_buf_len = len;
		}
	}
	else
	{
		LTE_PRINT(("collecting frame\n"));
		//collecting frame
		if((modem->frame_buf_len + len) > sizeof(modem->frame_buf))
		{
			printk("Can not collect a complete frame before the frame buffer full\n");
			modem->collecting_frame = 0;
			return;
		}
		memcpy(&modem->frame_buf[modem->frame_buf_len], buf, len);
		modem->frame_buf_len += len;

		if(modem->frame_buf_len == modem->frame_len)
		{
			//we got a complete frame
			lg_vl600_process_frame(modem, modem->frame_buf, modem->frame_buf_len);
			modem->collecting_frame = 0;
		}

		if(modem->frame_buf_len > modem->frame_len)
		{
			printk("WARNING!!! frame buf length > frame_len\n");
		}
	}
}

int lg_vl600_lte_tx_process(struct lte_modem_st * modem, char * tx_data, char * out_buf, int * len)
{
	int i, padded_len, packet_len;
	unsigned short protocol;

	if(!draytek_hw()) return -1;

    if(!modem->link_up) 
	{
		return -1;
	}
    
	protocol = ((unsigned char) tx_data[12] << 8) | (unsigned char) tx_data[13];

	memset(out_buf, 0, 24+14);
	if(protocol == 0x0806)
	{
		//ARP packet
		LTE_PRINT(("ARP Packet\n"));
		out_buf[14] = 4;
		out_buf[24 + 12] = 0x08;
		out_buf[24 + 13] = 0x06;

		memcpy(&out_buf[24 + 14], tx_data, *len);
		//sequence number (out_buf[4] ~ out_buf[7]) always zero

	}
	else
	{
		//IP packet
//		LTE_PRINT(("IP Packet\n"));

		//NOTE: IPV6 also use protocol 0x0800
		out_buf[24 + 12] = 0x08;
		out_buf[24 + 13] = 0x00;
		out_buf[4] = modem->counter_3 & 0xFF;
		out_buf[5] = (modem->counter_3 & 0xFF00) >> 8;
		out_buf[6] = (modem->counter_3 & 0xFF0000) >> 16;
		out_buf[7] = (modem->counter_3 & 0xFF000000) >> 24;
        modem->counter_3++;
		//exclude ethernet header
		*len -= 14;
		memcpy(&out_buf[24 + 14], &tx_data[14], *len);
	}

	packet_len = *len;

	padded_len = (24 + 14 + *len + 3) & ~3;
//	LTE_PRINT(("Tx Total length = %d\n", padded_len));
    for(i = 24 + 14 + *len; i < padded_len; i++) out_buf[i] = 0;

	//frame length
	out_buf[0] = padded_len & 0xFF;
	out_buf[1] = (padded_len & 0xFF00) >> 8;
	out_buf[2] = (padded_len & 0xFF0000) >> 16;
	out_buf[3] = (padded_len & 0xFF000000) >> 24;

	out_buf[8] = 1; //number of packet in this frame

	//packet length
	out_buf[24 + 8] = packet_len & 0xFF;
	out_buf[24 + 9] = (packet_len & 0xFF00) >> 8;
	out_buf[24 + 10] = (packet_len & 0xFF0000) >> 16;
	out_buf[24 + 11] = (packet_len & 0xFF000000) >> 24;

	*len = padded_len;

 //   lte_dump_buffer((unsigned char*)out_buf, *len, "Tx frame:\n");
	return 0;
}

int init_lg_vl600_lte(struct lte_modem_st * modem)
{
	unsigned char vl600_cmd_1[] =
	{
		0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,	
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   	
		0x10, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x05, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00,   
		0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 
	};

	unsigned char vl600_cmd_2[] =
	{
		0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,	
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   	
		0x08, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,   
	};

	unsigned char vl600_cmd_3[] =
	{
		0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,	
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   	
		0x08, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,   
	};	

	unsigned char buf[100], mac[6];
	char str[100];
	int act_count, i, j;
	check_draytek_hw();
	if(!draytek_hw()) return -1;

	modem->data_out_pipe	= os_usb_sndbulkpipe(modem->usb_dev, 2);
	modem->data_in_pipe		= os_usb_rcvbulkpipe(modem->usb_dev, 3);
 	modem->at_cmd_pipe 		= os_usb_sndbulkpipe(modem->usb_dev, 5);
	modem->at_rsp_pipe		= os_usb_rcvbulkpipe(modem->usb_dev, 6);

	//modem methods
	modem->rx_process = lg_vl600_lte_rx_process;
	modem->tx_process = lg_vl600_lte_tx_process;
    modem->timer_exe = lg_vl600_lte_timer;
	modem->config_rx_buf = lg_vl600_config_rx_buf;
	modem->get_config = lg_vl600_get_config;
	modem->report_info = lg_vl600_report_info;

	if((act_count = usb_control_in(modem->usb_dev, 0x06, 0x80, 0x0304, 0x0409, buf, 26, 1000)) < 0)
	{
		printk("VL600 get mac address failed, status = %d\n", act_count);
		return -1;
	}

	j = 0;
	for(i = 2; i < 26; i += 4)
	{
		str[j++] = buf[i];
		str[j++] = buf[i+2];
		str[j++] = ' ';
	}
	str[17] = 0;
	sscanf(str, "%x %x %x %x %x %x", &mac[0], &mac[1], &mac[2], &mac[3], &mac[4], &mac[5]);
    lte_update_mac(modem, (char*) mac);
	memcpy(modem->bssid, (char*) mac, 6); 
	modem->bssid[5] += 1;


    if(usb_bulk_msg_out(modem->usb_dev, 2, vl600_cmd_1, sizeof(vl600_cmd_1), &act_count, 1000) < 0)
	{
		printk("VL600 cmd 1 faild\n");
		return -1;
	}
//	lte_dump_buffer(vl600_cmd_1, act_count, "cmd 1\n");

    if(usb_bulk_msg_out(modem->usb_dev, 2, vl600_cmd_2, sizeof(vl600_cmd_2), &act_count, 1000) < 0)
	{
		printk("VL600  cmd2 faild\n");
		return -1;
	}
//	lte_dump_buffer(vl600_cmd_2, act_count, "cmd 2\n");

    if(usb_bulk_msg_out(modem->usb_dev, 2, vl600_cmd_3, sizeof(vl600_cmd_3), &act_count, 1000) < 0)
	{
		printk("VL600  cmd3 faild\n");
		return -1;
	}
//	lte_dump_buffer(vl600_cmd_3, act_count, "cmd 3\n");

    if(usb_bulk_msg_in(modem->usb_dev, 3, buf, sizeof(buf), &act_count, 1000) < 0)
	{
		printk("VL600 read 1'st response faild\n");
		return -1;
	}
	lte_dump_buffer(buf, act_count, "<---- 1'st response\n");
	lg_vl600_lte_rx_process(modem, buf, act_count);

    if(usb_bulk_msg_in(modem->usb_dev, 3, buf, sizeof(buf), &act_count, 1000) < 0)
	{
		printk("VL600 read 2'nd response faild\n");
		return -1;
	}
	lte_dump_buffer(buf, act_count, "<---- 2'nd response\n");
	lg_vl600_lte_rx_process(modem, buf, act_count);

	lg_vl600_send_p_cmd_sync(modem, 0x7E7E, 3, 0, 0x7E7E);
	lg_vl600_send_p_cmd_sync(modem, 0x01F1, 4, 0, 0xF1E1);
    lte_delay_ms(3000);
	lg_vl600_send_p_cmd_sync(modem, 0x7E7E, 3, 0, 0x7E7E);
	lg_vl600_send_p_cmd_sync(modem, 0x01F1, 4, 0, 0xF1E1);
    if(usb_bulk_msg_in(modem->usb_dev, 6, buf, sizeof(buf), &act_count, 3000) < 0)
	{
		printk("VL600 read 1'st P response faild\n");
		return -1;
	}

	lte_dump_buffer(buf, act_count, "<---- 1'st P response\n");

	if(start_at_rsp_rx(modem) < 0) return -1;

#if 1
    send_at_cmd_sync(modem, "ATE0V1\r");

    send_at_cmd_sync(modem, "AT+CMEE=1\r");

    send_at_cmd_sync(modem, "AT+CPIN?\r");

    send_at_cmd_sync(modem, "AT+CLCK=\"SC\",2\r");
#endif

	strcpy(modem->sw_ver, "2202");
	strcpy(modem->hw_ver, "LG VL600");
	printk("LG VL600 modem initialized successfully\n");

	return 0;
}

#endif //LG_VL600_LTE_SUPPORT == 1
