#include <linux/autoconf.h>
#include <linux/string.h>
#include <linux/kernel.h>
#include "lte_driver.h"
#include "os_shim.h"
static char * reg_status_str[6] =
{
    "not registered",
    "registered, home network",
    "searching",
    "registration denied",
    "unknown",
    "registered"
};

static char * network_type_str[8] =
{
    "GSM",
    "GSM Compact",
    "UTRAN",
    "GSM w/EGPRS", 
    "UTRAN w/HSDPA", 
    "UTRAN w/HSUPA",
    "UTRAN w/HSDPA and HSUPA", 
    "E-UTRAN"
};

extern void (*draytek_get_flash_mac_fun)(unsigned char *);
static int draytek_router = 0;
int draytek_hw(void)
{
	return draytek_router;
}

void check_draytek_hw(void)
{
	unsigned char hw_mac[7];

	#if 0
	/* Please make sure this driver is installed after : dray_hw module. */
	if(draytek_get_flash_mac_fun){
		draytek_get_flash_mac_fun(hw_mac);
		if(hw_mac[6]){
				printk("Not draytek hardware......\n");
				printk("MAC READ  %02X:%02X:%02X:%02X:%02X:%02X:%02X\n", hw_mac[0], hw_mac[1], hw_mac[2], 
				          hw_mac[3], hw_mac[4], hw_mac[5], hw_mac[6]);

			draytek_router = 0;
			return;
		}
	}else{
		/* driver install sequence not correct. */
		draytek_router = 0;
		return;
	}
	#endif

	draytek_router = 1;
}

int string_found(char * str, char * buf, int len)
{
    int i;

    if(len < strlen(str)) return -1;

    for(i=0; i<(len - strlen(str)); i++)
    {
        if(strncmp(&buf[i], str, strlen(str)) == 0) 
        {
//            WIMAX_PRINT( LOG_INFO, "%s found", str);
            return i;
        }
    }
    return -1;
}

void zero_terminate(char * str)
{
	int i;
	for(i = 0; i < strlen(str); i++)
	{
		if(str[i] == 0x0D || str[i] == 0x0A)
		{
			str[i] = 0;
			return;
		}
	}
	return;
}

static int not_dgt(char ch)
{
    if(ch > 0x39) return 1;
    if(ch < 0x30) return 1;
    return 0;
}

static int pin_code_invalid(char * pin)
{
	int i;
	if(strlen(pin) < 4 || strlen(pin) > 8)
	{
		printk("PIN code length is wrong\n");
		return 1;
	}

	for(i = 0; i< strlen(pin); i++)
	{
		if(not_dgt(pin[i])) return 1;
	}
	return 0;
}

extern int send_at_cmd_sync(struct lte_modem_st * modem, char * at_cmd);

int check_sim_card(struct lte_modem_st * modem)
{
	int i, remain_cnt = -1;
	char cmd_buf[40], str[10], * str_end;

	//check remaining count
	if(send_at_cmd_sync(modem, "AT+CPINREMAINCNT?\r") < 0)
	{
		printk("read SIM card remaining count failed\n");
		return -1;
	}

	i = string_found("+CPINREMAINCNT:", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
	if(i >= 0)
	{
		str[0] = modem->at_rsp_buf[ i + 16];
		str[1] = 0;
		remain_cnt = simple_strtol(str, &str_end, 10);

		LTE_PRINT(("SIM Card remaining count = %d\n", remain_cnt));
	}

	//check SIM card status
	if(send_at_cmd_sync(modem, "AT+CPIN?\r") < 0)
	{
        printk("read SIM card status failed\n");
		//power cycle the modem
		reset_device(modem);
		return -1;
	}

	//Check if SIM card ready
	i = string_found("READY", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
	if(i >= 0)
	{
		LTE_PRINT(("SIM Card okay\n"));
		return 0;
	}

	//SIM card not ready, SIM card is not inserted ?
	i = string_found("failure", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
	if(i >= 0)
	{
		printk("No SIM card found! Please insert SIM card\n");
		return -1;
	}

	//need PIN code ?
	i = string_found("SIM PIN", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
	if(i >= 0)
	{
		if(remain_cnt == -1)
		{
			printk("Can't read SIM card pin code remaining count!!!!!!\n");
			printk("Please use PC dialer to check SIM card\n");
			return -1;
		}

		if(remain_cnt < 2)
		{
			printk("SIM card remaining count < 2 !!!!!!\n");
			printk("Please use PC dialer to set correct PIN code\n");
			return -1;
		}

		if(pin_code_invalid(modem->pin_code))
		{
			//don't load an invalid PIN code to modem, it could be really an invalid PIN code, 
			//or it is set to "Wrong PIN" due to verification fail
			printk("invalid PIN\n");
			return -1;
		}
			
		//set pin code
		sprintf(cmd_buf, "AT+CPIN=\"%s\"\r", modem->pin_code);
		printk("AT+CPIN=\"XXXX\"\n");

		if(send_at_cmd_sync(modem, cmd_buf) < 0)
		{
			printk("AT+CPIN=\"XXXX\" failed\n");
			return -1;
		}

		i = string_found("OK", modem->at_rsp_buf, strlen(modem->at_rsp_buf));
		if(i >= 0)
		{
			LTE_PRINT(("PIN code set okay\n"));
			return 0;
		}

		//pin code set failed, change PIN code to "Wrong PIN"
		printk("PIN incorrect\n");
		lte_send_ap_set_pin_invalid(modem);
		return -1;
	}
}

static int check_modem_state(struct lte_modem_st * modem, char * buf, int len)
{
	int i, new_state;
    char str[10], * str_end;

	i = string_found("+NWSTATEIND:", buf, len);
	if(i >= 0)
	{
		str[0] = buf[i+13];
		str[1] = 0;
		new_state = simple_strtol(str, &str_end, 10);

		if(new_state != modem->state)
		{
			printk("modem state %d -----> %d\n", modem->state, new_state);
			if(new_state == 6 && modem->connect_timer == 0)
			{
				//link up
				lte_link_up(modem);
			}
			else 
			{
#if 0
				if(modem->state == 6 && modem->link_up/* && new_state == 4*/)
				{
					//link down
					printk("********* 4G link down **********\n");
					lte_link_down(modem);
					modem->connect_timer = 2;
				}
#endif
			}
			modem->state = new_state;
		}
	}
	return i;
}

void process_at_rsp(struct lte_modem_st * modem, char * p, int len)
{
    int i;
    int new_state, attach_done;
    int dbm, reg_status;
    char str[10], * str_end;

	if(!draytek_hw()) return;
//	lte_dump_buffer(p, len, "at response");
	//zero terminate the string in buffer
	p[len] = 0;

	printk("<-- %s", p);

	//check unsolicited +CGACT= 1,1 for link up
	i = string_found("+CGACT: 1,1", p, len);
	if(i > 0)
	{
		lte_link_up(modem);
		modem->attach_status = 1;
	}

	//check solicited +CGACT=1,1 
	i = string_found("+CGACT:1,1", p, len);
	if(i > 0)
	{
		modem->attach_status = 1;
	}

#if 1
	//check unsolicited +CGACT= 1,0 for link down
	i = string_found("+CGACT: 1,0", p, len);
	if(i > 0 && modem->link_up)
	{
		//link down
		lte_link_down(modem);

		//try to reconnect 2 seconds later
		if(!modem->in_handshake) modem->connect_timer = 2;
	}
#endif

	//check modem state information
#if 0
	i = string_found("+NWSTATEIND:", p, len);
	if(i >= 0)
	{
		str[0] = p[i+13];
		str[1] = 0;
		new_state = simple_strtol(str, &str_end, 10);

		if(new_state != modem->state)
		{
			printk("modem state %d -----> %d\n", modem->state, new_state);
			if(new_state == 6)
			{
				//link up
				lte_link_up(modem);
			}
			else 
			{
				if(modem->state == 6 && modem->link_up && new_state == 4)
				{
					//link down
					printk("********* 4G link down **********\n");
					lte_link_down(modem);
					modem->connect_timer = 2;
				}
			}
			modem->state = new_state;
		}
	}
#else
	//check +NWSTATEIND twice, we could have 2 state indications in one response
	i = check_modem_state(modem, p, len);
	if(i >= 0 && (len - i - 1) > 0 )
	{
		check_modem_state(modem, p + i + 1, len - i - 1);
	}
#endif
	//check attach done indication
	i = string_found("+ATTACHDONEIND:", p, len);
	if(i >= 0)
	{
		str[0] = p[i+16];
		str[1] = 0;
		attach_done = simple_strtol(str, &str_end, 10);
		printk("%s\n", attach_done?"Attched":"Detached");
	}

	//check signal quality
	i = string_found("+CSQ:", p, len);
	if(i >= 0)
	{
		str[0] = p[i+6];
		str[1] = p[i+7];
		str[2] = 0;
		dbm = simple_strtol(str, &str_end, 10);
		if(dbm == 99)
		{
			printk("signal not detectable!\n");
		}
		else
		{
			modem->dbm = dbm;
			dbm = -113 + dbm * 2;
			printk("rssi = %d dbm\n", dbm);
			modem->rssi = dbm;
			modem->cinr = 100 + dbm;
			if(modem->link_status < 2 ) 
			{
				modem->link_status = 1;
				lte_send_ap_link_status(modem);
			}
			else
			{
/*
				if(dbm < -106)
				{
					printk("********* link down **********\n");
					lte_link_down(modem);
					modem->connect_timer = 2;
				}
*/
			}
		}
	}	

	//check functionality
	i = string_found("+CFUN:", p, len);
	if(i >= 0)
	{
		str[0] = p[i+6];
		str[1] = 0;
		modem->functionality = simple_strtol(str, &str_end, 10);
	}

	//check attach status
	i = string_found("+CGATT:", p, len);
	if(i >= 0)
	{
		str[0] = p[i+7];
		str[1] = 0;
		modem->attach_status = simple_strtol(str, &str_end, 10);
	}
	//check attach status
	i = string_found("+CHANGEALLPATH:", p, len);
	if(i >= 0)
	{
		str[0] = p[i+15];
		str[1] = 0;
		modem->changeallpath = simple_strtol(str, &str_end, 10);
	}
	//check +CGREG: network registration status 
	i = string_found("+CGREG:", p, len);
	if(i >= 0)
	{
		str[0] = p[i+8];
		str[1] = 0;
		reg_status = simple_strtol(str, &str_end, 10);

		str[0] = p[i+20];
		str[1] = 0;
		modem->network_connected = simple_strtol(str, &str_end, 10);
		printk("%s network [%s], loc code = %c%c%c%c, Cell ID = %c%c%c%c, Route Code = %c%c%c%c\n", 
			         network_type_str[modem->network_connected ], reg_status_str[reg_status], 
					 p[i+10], p[i+11], p[i+12], p[i+13], 
					 p[i+15], p[i+16], p[i+17], p[i+18], 
					 p[i+22], p[i+23], p[i+24], p[i+25]
					);
		if(modem->link_up) lte_send_ap_network_type(modem);
	}

	//check +CREG: network registration status 
	i = string_found("+CREG:", p, len);
	if(i >= 0)
	{
		str[0] = p[i+7];
		str[1] = 0;
		reg_status = simple_strtol(str, &str_end, 10);

		str[0] = p[i+19];
		str[1] = 0;
		modem->network_connected = simple_strtol(str, &str_end, 10);
		printk("%s network [%s], loc code = %c%c%c%c, Cell ID = %c%c%c%c, Route Code = %c%c%c%c\n", 
			         network_type_str[modem->network_connected ], reg_status_str[reg_status], 
					 p[i+9], p[i+10], p[i+11], p[i+12], 
					 p[i+14], p[i+15], p[i+16], p[i+17], 
					 p[i+21], p[i+22], p[i+23], p[i+24]
					);

		if(modem->link_up) lte_send_ap_network_type(modem);
	}

	//got_rsp = 1 (OK); 2, (TIME OUT); 3 (ERROR)
	if(string_found("OK", p, len) >= 0)
	{
		modem->got_rsp = 1;
	}

	if(string_found("TIME", p, len) >= 0)
	{
		modem->got_rsp = 2;
	}

	if(string_found("ERROR", p, len) >= 0)
	{
		modem->got_rsp = 3;
	}

}

