#include <linux/autoconf.h>
#ifndef LTE_DRIVER_H
#define LTE_DRIVER_H

//Driver Configuration
#define LTE_USE_PRE_ALLOC_TX_BUF    0
#define LTE_USE_KERNEL_TIMER        0
#define LTE_MAX_DATA_RX_BUF			64
#define LTE_MAX_DATA_TX_BUF			128 //must be a power of 2

#define NET_DEV_NAME                "wimax"

//modems we support
#define SAMSUNG_LTE_SUPPORT 1       //B3730 modem
#define LG_VL600_LTE_SUPPORT 1      //LG VL600

//testing flags, should be all 0 for normal operation
#define LTE_TEST_DAEMON     0
#define LTE_TEST_DHCPC      0

//Debug message Print 
#define LTE_DRIVER_DBG				1           
#define LTE_DRIVER_TRACE			1
#define LTE_DRIVER_TRACE_P			0
#define LTE_DRIVER_TRACE_USER_IF	0
#define LTE_DRIVER_DUMP_TX_RX       0

#if LTE_DRIVER_DBG == 1
	#define LTE_PRINT(_x_) { printk _x_;}
#else
	#define LTE_PRINT(_x_) 
#endif


#if LTE_DRIVER_TRACE == 1
	#define LTE_TRACE(_x_) { printk _x_;}
#else
	#define LTE_TRACE(_x_) 
#endif

#if LTE_DRIVER_TRACE_P == 1
	#define LTE_TRACE_P(_x_) { printk _x_;}
#else
	#define LTE_TRACE_P(_x_) 
#endif

#if LTE_DRIVER_TRACE_USER_IF == 1
	#define LTE_TRACE_USER_IF(_x_) { printk _x_;}
#else
	#define LTE_TRACE_USER_IF(_x_) 
#endif


//private io control
#define LTE_NET_READ  SIOCDEVPRIVATE
#define LTE_NET_WRITE SIOCDEVPRIVATE+1

#define IO_EAP_PACKET   0
#define IO_SHELL_CMD    1
#define IO_TERMINATE    2
struct lte_ioctl_data_st
{
	int type;
	unsigned char buf[2000];
	int buf_len;
};

enum lte_network_mode
{
	MULTI_MODE = 0,
	ONLY_4G,
	ONLY_3G,
	ONLY_2G
};

struct my_list_head {
	struct my_list_head *next, *prev;
};


//modem object
struct lte_modem_st 
{
	struct			my_list_head list;  
	void          * usb_if;					//struct usb_interface *
	void          * net_dev;				//struct net_device *
	void          * at_rsp_urb;				//struct urb *
	void          * usb_dev;				//struct usb_device *
	void          * work_q;					//struct workqueue_struct *

	void		  *	timer;					//struct timer_list *
	void          * statistic;				//struct net_device_stats *
	void		  *	task_level_timer;		//struct delayed_work *
	void          * spin_lock;
	void          * current_tx_urb;

	//the actual rx buffers used is determined by act_rx_buf_count which must be less than LTE_MAX_DATA_RX_BUF, 
	//rx buffer size is determined by rx_buf_size
	void          * data_rx_urb[LTE_MAX_DATA_RX_BUF];
	void          * data_rx_skb[LTE_MAX_DATA_RX_BUF];
	unsigned char *	data_rx_dma_buf[LTE_MAX_DATA_RX_BUF];

	//the actual tx buffers used is determined by act_tx_buf_count which must be less than LTE_MAX_DATA_TX_BUF
	//, act_tx_buf_count must be a power of 2, tx buffer size is determined by tx_buf_size
	void          * data_tx_urb[LTE_MAX_DATA_TX_BUF];
	unsigned char *	data_tx_dma_buf[LTE_MAX_DATA_TX_BUF];
	int				tx_buf_index;
	int				tx_buf_left;

	int				vid;
	int				pid;
	int				counter;
	int				ready;


	//modem information
	char			bssid[6];
	char			hw_ver[60];
	char			sw_ver[60];
	int				rssi;
	int				cinr;
	int				dbm;
	char            apn[30];
	char			pin_code[20];
	int				network_mode;         
	int				network_connected;

	//usb endpoints
	int				data_in_pipe;
	int				data_out_pipe;
	int				at_cmd_pipe;
	int				at_rsp_pipe;
	int				act_rx_buf_count;
	int				rx_buf_size;
	int				rx_head_room;
	int				rx_use_dma_buf;
	int				act_tx_buf_count;
	int				tx_buf_size;
	char          * at_rsp_buf;  
	int				got_rsp;
	int				attach_status;
	int				changeallpath;
	int             functionality;
	int				link_up;
	int				link_status;
	int				state;
	int				disconnected;

	//general purpose counters
	int             counter_1;
	int             counter_2;
	int             counter_3;
	
	int				connect_timer;
	int				in_handshake;
	int				hs_timer;
	int				seg1_len;
	int				seg2_len;
	unsigned char	seg_buf[1600];
	unsigned char   ping_packet[74];   //the size should be the same as ping_template[]
	int				my_ip_dns_ip_valid;
	unsigned char   my_ip[4];
	unsigned char   dns_ip[4];
	int             keep_alive_timer;

	//modem methods
	void (* rx_process)(struct lte_modem_st * modem, char * buf, int len);
	int  (* tx_process)(struct lte_modem_st * modem, char * tx_data, char * out_buf, int * len);
	void (* timer_exe) (struct lte_modem_st * modem);
	void (* config_rx_buf) (struct lte_modem_st * modem);
	void (* get_config) (struct lte_modem_st * modem);
	void (* report_info) (struct lte_modem_st * modem);

	//used by LG_VL600
#if LG_VL600_LTE_SUPPORT == 1	
	int collecting_frame;
	int frame_len;
	int frame_buf_len;
	char frame_buf[64 * 1024];
#endif
	//io control
	int io_data_valid;
	struct lte_ioctl_data_st io_data;
};

void lte_send_ap_modem_power_recycle(struct lte_modem_st * modem);
void lte_send_ap_modem_connected(struct lte_modem_st * modem);
void lte_send_ap_modem_disconnected(struct lte_modem_st * modem);
void lte_delay_ms(int delay_ms);
void lte_link_up(struct lte_modem_st * modem);
void lte_link_down(struct lte_modem_st * modem);
void lte_dump_buffer( unsigned char * buf, int len, char * begin_str);
void lte_send_ap_hw_ver(struct lte_modem_st * modem);
void lte_send_ap_sw_ver(struct lte_modem_st * modem);
void lte_send_ap_mac(struct lte_modem_st * modem);
void lte_send_ap_bssid(struct lte_modem_st * modem);
void lte_send_ap_link_status(struct lte_modem_st * modem);
void lte_send_ap_link_up(struct lte_modem_st * modem);
void lte_send_ap_link_down(struct lte_modem_st * modem);
void lte_send_ap_set_pin_invalid(struct lte_modem_st * modem);
void lte_send_ap_rx_packet(struct lte_modem_st * modem, unsigned char * buf, int len);
void lte_send_ap_network_type(struct lte_modem_st * modem);
struct lte_modem_st * if_name_to_modem(char * if_name);
int start_data_rx(struct lte_modem_st * modem);
void lte_tx_comp(void * urb);
int lte_netif_rx(struct lte_modem_st * modem, char * buf, int len);
void setup_ping_dns_packet(struct lte_modem_st * modem);
int set_config(struct usb_device * usb_dev, int config_num);
int get_config_desc(struct lte_modem_st * modem);
int get_device_desc(struct lte_modem_st * modem);
int get_config(struct lte_modem_st * modem);

#endif //LTE_DRIVER_H
