#ifndef _OS_SIM_H
#define _OS_SIM_H
int usb_control_in(void *usb_dev, unsigned char request, unsigned char requesttype,
			 unsigned short value, unsigned short index, void *data, unsigned short size, int timeout);

int usb_control_out(void *usb_dev, unsigned char request, unsigned char requesttype,
			 unsigned short value, unsigned short index, void *data, unsigned short size, int timeout);

int usb_bulk_msg_out(void *usb_dev, unsigned int pipe, void *data, int len, int *actual_length, int timeout);

int usb_bulk_msg_in(void *usb_dev, unsigned int pipe, void *data, int len, int *actual_length, int timeout);

int reset_device(struct lte_modem_st * modem);

void power_recycle_device(struct lte_modem_st * modem);

int reset_device_no_modem_object(void * usb_dev);

void * os_kmalloc(int len);

void lte_update_mac(struct lte_modem_st * modem, char *  mac);

void update_rx_drop_cnt(struct lte_modem_st * modem);
void update_tx_drop_cnt(struct lte_modem_st * modem);

int os_usb_sndbulkpipe(void * usb_dev, int pipe);
int os_usb_rcvbulkpipe(void * usb_dev, int pipe);
void fill_modem_mac(struct lte_modem_st * modem, char * buf);

#endif