/*******************************************************************************
 *
 *  Copyright(c) 2006 Star Semiconductor Corporation, All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along with
 *  this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *  The full GNU General Public License is included in this distribution in the
 *  file called LICENSE.
 *
 *  Contact Information:
 *  Technology Support <tech@starsemi.com>
 *  Star Semiconductor 4F, No.1, Chin-Shan 8th St, Hsin-Chu,300 Taiwan, R.O.C
 *
 ******************************************************************************/

#ifndef _STAR_POWERMGT_H_
#define _STAR_POWERMGT_H_

#include <asm/arch/star_sys_memory_map.h>

#if defined(__UBOOT__)
#define PWRMGT_MEM_MAP_VALUE(reg_offset)		(*((u32 volatile *)(SYSPA_POWER_MANAGEMENT_BASE_ADDR + reg_offset)))
#elif defined(__LINUX__)
#define PWRMGT_MEM_MAP_VALUE(reg_offset)		(*((u32 volatile *)(SYSVA_POWER_MANAGEMENT_BASE_ADDR + reg_offset)))
#else
#error "NO SYSTEM DEFINED"
#endif


#define PWRMGT_CLOCK_GATE_CONTROL0_REG			PWRMGT_MEM_MAP_VALUE(0x00)
#define PWRMGT_CLOCK_GATE_CONTROL1_REG			PWRMGT_MEM_MAP_VALUE(0x04)
#define PWRMGT_SOFTWARE_RESET_CONTROL_REG		PWRMGT_MEM_MAP_VALUE(0x08)
#define PWRMGT_SYSTEM_CLOCK_CONTROL_REG			PWRMGT_MEM_MAP_VALUE(0x0C)
#define PWRMGT_PLL_POWER_DOWN_CONTROL_REG		PWRMGT_MEM_MAP_VALUE(0x10)
#define PWRMGT_PAD_DRIVE_STRENGTH_CONTROL_REG		PWRMGT_MEM_MAP_VALUE(0x1C)
#define PWRMGT_REGULATOR_CONTROL_REG			PWRMGT_MEM_MAP_VALUE(0x24)


/*
 * define constants macros
 */
#define PWRMGT_SMC_SOFTWARE_RESET_BIT_INDEX		(1)
#define PWRMGT_IDP_SOFTWARE_RESET_BIT_INDEX		(2)
#define PWRMGT_VIC_SOFTWARE_RESET_BIT_INDEX		(3)
#define PWRMGT_DMA_SOFTWARE_RESET_BIT_INDEX		(4)
#define PWRMGT_GSW_SOFTWARE_RESET_BIT_INDEX		(5)
#define PWRMGT_USB_HOST_SOFTWARE_RESET_BIT_INDEX	(6)
#define PWRMGT_PCI_BRIDGE_SOFTWARE_RESET_BIT_INDEX	(7)
#define PWRMGT_P2S_SOFTWARE_RESET_BIT_INDEX		(8)
#define PWRMGT_UART0_SOFTWARE_RESET_BIT_INDEX		(9)
#define PWRMGT_UART1_SOFTWARE_RESET_BIT_INDEX		(10)
#define PWRMGT_TIMER_SOFTWARE_RESET_BIT_INDEX		(11)
#define PWRMGT_WDTIMER_SOFTWARE_RESET_BIT_INDEX		(12)
#define PWRMGT_GPIO_SOFTWARE_RESET_BIT_INDEX		(13)
#define PWRMGT_HSDMA_SOFTWARE_RESET_BIT_INDEX		(16)
#define PWRMGT_VTSS_SWITCH_SOFTWARE_RESET_BIT_INDEX	(17)
#define PWRMGT_VTSS_AHB_SLAVE_SOFTWARE_RESET_BIT_INDEX	(18)


#define PWRMGT_PLL_FREQUENCY_166MHZ			(4 << 0)
#define PWRMGT_PLL_FREQUENCY_200MHZ			(5 << 0)
#define PWRMGT_PLL_FREQUENCY_233MHZ			(6 << 0)
#define PWRMGT_PLL_FREQUENCY_266MHZ			(7 << 0)
#define PWRMGT_PLL_FREQUENCY_300MHZ			(8 << 0)
#define PWRMGT_PLL_FREQUENCY_333MHZ			(9 << 0)
#define PWRMGT_PLL_FREQUENCY_366MHZ			(10 << 0)
#define PWRMGT_PLL_FREQUENCY_400MHZ			(11 << 0)

/*
 * Macro defines for Clock Gate Control
 */
#define HAL_PWRMGT_DISABLE_DRAMC_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL0_REG &= ~((0x1 << 0)); \
}

#define HAL_PWRMGT_ENABLE_SMC_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 7)); \
    PWRMGT_CLOCK_GATE_CONTROL0_REG |= ((0x1 << 4) | (0x1 << 5)); \
}

#define HAL_PWRMGT_DISABLE_SMC_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL0_REG &= ~((0x1 << 4) | (0x1 << 5)); \
}

#define HAL_PWRMGT_ENABLE_IDP_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 7)); \
    PWRMGT_CLOCK_GATE_CONTROL0_REG |= ((0x1 << 8) | (0x1 << 9)); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_IDP_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_DISABLE_IDP_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL0_REG &= ~((0x1 << 8) | (0x1 << 9)); \
}

#define HAL_PWRMGT_ENABLE_VIC_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 7)); \
    PWRMGT_CLOCK_GATE_CONTROL0_REG |= (0x1 << 12); \
}

#define HAL_PWRMGT_DISABLE_VIC_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL0_REG &= ~(0x1 << 12); \
}

#define HAL_PWRMGT_ENABLE_DMA_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 7)); \
    PWRMGT_CLOCK_GATE_CONTROL0_REG |= (0x1 << 16); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_DMA_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_DISABLE_DMA_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL0_REG &= ~(0x1 << 16); \
}

#define HAL_PWRMGT_ENABLE_GSW_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 7)); \
    PWRMGT_CLOCK_GATE_CONTROL0_REG |= ((0x1 << 20) | (0x1 << 22) | (0x1 << 23)); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_GSW_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_DISABLE_GSW_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL0_REG &= ~((0x1 << 20) | (0x1 << 22) | (0x1 << 23)); \
}

#define HAL_PWRMGT_ENABLE_USB_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 2) | (0x1 << 7)); \
    PWRMGT_CLOCK_GATE_CONTROL0_REG |= (0x1 << 24); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_USB_HOST_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_DISABLE_USB_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL0_REG &= ~(0x1 << 24); \
}

#define HAL_PWRMGT_ENABLE_PCI_BRIDGE_33M_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~(0x1 << 7); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~(0x3 << 10); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= (0x1 << 10); \
    PWRMGT_CLOCK_GATE_CONTROL0_REG |= (0x1 << 28) | (0x1 << 30); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_PCI_BRIDGE_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_ENABLE_PCI_BRIDGE_66M_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~(0x1 << 7); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~(0x3 << 10); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= (0x0 << 10); \
    PWRMGT_CLOCK_GATE_CONTROL0_REG |= (0x1 << 28) | (0x1 << 30); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_PCI_BRIDGE_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_DISABLE_PCI_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL0_REG &= ~((0x1 << 28) | (0x1 << 30)); \
}

/*
 * Macro-defines for PWRMGT_CLOCK_GATE_CONTROL1_REG
 */
#define HAL_PWRMGT_ENABLE_SPI_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 0) | (0x1 << 1); \
}

#define HAL_PWRMGT_DISABLE_SPI_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 0); \
}

#define HAL_PWRMGT_ENABLE_PCM_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 5) | (0x1 << 8)); \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 1) | (0x1 << 6); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_P2S_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_DISABLE_PCM_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 6); \
}

#define HAL_PWRMGT_ENABLE_I2S_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 5) | (0x1 << 6) | (0x1 << 8)); \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 1) | (0x1 << 10); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_P2S_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_DISABLE_I2S_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 10); \
}

#define HAL_PWRMGT_ENABLE_UART0_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 2) | (0x1 << 5) | (0x1 << 8)); \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 12); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_UART0_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_DISABLE_UART0_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 12); \
}

#define HAL_PWRMGT_ENABLE_UART1_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 2) | (0x1 << 5) | (0x1 << 8)); \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 13); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_UART1_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_DISABLE_UART1_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 13); \
}

#define HAL_PWRMGT_ENABLE_TIMER_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 17); \
}

#define HAL_PWRMGT_DISABLE_TIMER_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 17); \
}

#define HAL_PWRMGT_ENABLE_WDTIMER_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 21); \
}

#define HAL_PWRMGT_DISABLE_WDTIMER_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 21); \
}

#define HAL_PWRMGT_ENABLE_RTC_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 23); \
}

#define HAL_PWRMGT_DISABLE_RTC_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 23); \
}

#define HAL_PWRMGT_ENABLE_GPIO_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 25); \
}

#define HAL_PWRMGT_DISABLE_GPIO_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 25); \
}

#define HAL_PWRMGT_ENABLE_HSDMA_CLOCK() \
{ \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~((0x1 << 7)); \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 29); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1 << PWRMGT_HSDMA_SOFTWARE_RESET_BIT_INDEX); \
}

#define HAL_PWRMGT_DISABLE_HSDMA_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 29); \
}

#define HAL_PWRMGT_ENABLE_I2C_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG |= (0x1 << 1); \
}

#define HAL_PWRMGT_DISABLE_I2C_CLOCK() \
{ \
    PWRMGT_CLOCK_GATE_CONTROL1_REG &= ~(0x1 << 1); \
}

/*
 * Macro defines for PWRMGT_SOFTWARE_RESET_CONTROL_REG
 */
#define HAL_PWRMGT_GLOBAL_SOFTWARE_RESET() \
{ \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG |= (0x1); \
    PWRMGT_SOFTWARE_RESET_CONTROL_REG &= ~(0x1); \
}

/*
 * Macro defines for PWRMGT_SYSTEM_CLOCK_CONTROL_REG
 */
#define HAL_PWRMGT_SET_PLL_FREQUENCY_166MHZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~0xF; \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= PWRMGT_PLL_FREQUENCY_166MHZ; \
}

#define HAL_PWRMGT_SET_PLL_FREQUENCY_200MHZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~0xF; \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= PWRMGT_PLL_FREQUENCY_200MHZ; \
}

#define HAL_PWRMGT_SET_PLL_FREQUENCY_233MHZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~0xF; \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= PWRMGT_PLL_FREQUENCY_233MHZ; \
}

#define HAL_PWRMGT_SET_PLL_FREQUENCY_266MHZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~0xF; \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= PWRMGT_PLL_FREQUENCY_266MHZ; \
}

#define HAL_PWRMGT_SET_PLL_FREQUENCY_300MHZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~0xF; \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= PWRMGT_PLL_FREQUENCY_300MHZ; \
}

#define HAL_PWRMGT_SET_PLL_FREQUENCY_333MHZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~0xF; \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= PWRMGT_PLL_FREQUENCY_333MHZ; \
}

#define HAL_PWRMGT_SET_PLL_FREQUENCY_366MHZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~0xF; \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= PWRMGT_PLL_FREQUENCY_366MHZ; \
}

#define HAL_PWRMGT_SET_PLL_FREQUENCY_400MHZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~0xF; \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= PWRMGT_PLL_FREQUENCY_400MHZ; \
}

#define HAL_PWRMGT_CONFIG_PLLCLK_TO_CPUCLK_RATIO(ratio) \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~(0x3 << 4); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= (((ratio - 1) & 0x3) << 4); \
}

#define HAL_PWRMGT_CONFIG_CPUCLK_TO_HCLK_RATIO(ratio) \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~(0x3 << 6); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= (((ratio - 1) & 0x3) << 6); \
}

#define HAL_PWRMGT_I2S_CLOCK_SOURCE_8192000HZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~(0x3 << 12); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= (0x0 << 12); \
}

#define HAL_PWRMGT_I2S_CLOCK_SOURCE_11289600HZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~(0x3 << 12); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= (0x1 << 12); \
}

#define HAL_PWRMGT_I2S_CLOCK_SOURCE_12288000HZ() \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~(0x3 << 12); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= (0x2 << 12); \
}

#define HAL_PWRMGT_CONFIGURE_MDC_CLOCK_DIVIDER(divided_value) \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~(0x3 << 14); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= ((divided_value & 0x3) << 14); \
}

#define HAL_PWRMGT_CONFIGURE_CLOCK_OUT_PIN(pin_source_select, divided_value) \
{ \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG &= ~(0x3F << 16); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= ((pin_source_select & 0xF) << 16); \
    PWRMGT_SYSTEM_CLOCK_CONTROL_REG |= ((divided_value & 0x3) << 20); \
}

/*
 * Macro defines for PLL Power Down Control
 */
#define HAL_PWRMGT_POWER_DOWN_PLLD5M3() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG |= (0x1 << 2)

#define HAL_PWRMGT_POWER_ON_PLLD5M3() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~(0x1 << 2)

#define HAL_PWRMGT_POWER_DOWN_PLLM9() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG |= (0x1 << 5)

#define HAL_PWRMGT_POWER_ON_PLLM9() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~(0x1 << 5)

#define HAL_PWRMGT_POWER_DOWN_PLLD8M49() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG |= (0x1 << 6)

#define HAL_PWRMGT_POWER_ON_PLLD8M49() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~(0x1 << 6)

#define HAL_PWRMGT_POWER_DOWN_CPU_PLL() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG |= (0x1 << 7)

#define HAL_PWRMGT_POWER_ON_CPU_PLL() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~(0x1 << 7)

#define HAL_PWRMGT_POWER_DOWN_AUDIO_XTAL() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG |= (0x1 << 8)

#define HAL_PWRMGT_POWER_ON_AUDIO_XTAL() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG &= ~(0x1 << 8)

#define HAL_PWRMGT_POWER_DOWN_ALL_PLLS_EXCEPT_CPU_PLL() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG = (0x1 << 2) | (0x1 << 5) | (0x1 << 6) | (0x1 << 8);

#define HAL_PWRMGT_POWER_ON_ALL_PLLS() \
    PWRMGT_PLL_POWER_DOWN_CONTROL_REG = 0;

/*
 * Macro defines for Pad Drive Strength Control
 */
#define HAL_PWRMGT_SELECT_PAD_DRIVE_STRENGTH_CARDBUS_MODE() \
{ \
    PWRMGT_PAD_DRIVE_STRENGTH_CONTROL_REG &= ~(0x1 << 0); \
}

#define HAL_PWRMGT_SELECT_PAD_DRIVE_STRENGTH_PCI_MODE() \
{ \
    PWRMGT_PAD_DRIVE_STRENGTH_CONTROL_REG |= (0x1 << 0); \
}

#endif  // end of #ifndef _STAR_POWERMGT_H_
